package com.atlassian.audit.frontend.conditions;

import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;

import java.util.Map;

/**
 * A condition which checks if the user can view global auditing UI.
 */
public class CanViewGlobalUICondition implements Condition {

    private final PermissionChecker permissionChecker;

    public CanViewGlobalUICondition(PermissionChecker permissionChecker) {
        this.permissionChecker = permissionChecker;
    }

    @Override
    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> stringObjectMap) {
        return permissionChecker.hasUnrestrictedAuditViewPermission();
    }
}
