package com.atlassian.audit.file;

import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.rest.utils.AuditEntitySerializer;
import com.atlassian.audit.spi.feature.FileAuditingFeature;

import java.util.List;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

/**
 * Implementation of AuditConsumer to record Audit Entries to a rolling file.
 */
public class FileAuditConsumer implements AuditConsumer {

    public static final String DEFAULT_AUDIT_FILE_DIR = "log/audit";

    private final FileAuditingFeature fileAuditingFeature;
    private final FileMessagePublisher fileHandler;

    public FileAuditConsumer(FileAuditingFeature fileAuditingFeature,
                             FileMessagePublisher fileHandler) {
        this.fileAuditingFeature = fileAuditingFeature;
        this.fileHandler = fileHandler;
    }

    @Override
    public void accept(List<AuditEntity> entities) {
        requireNonNull(entities, "entities");
        fileHandler.publish(entities.stream()
                .filter(Objects::nonNull)
                .map(AuditEntitySerializer::serialize)
                .toArray(String[]::new));
    }

    @Override
    public boolean isEnabled() {
        return fileAuditingFeature.isEnabled();
    }
}
