package com.atlassian.audit.file;

import com.atlassian.audit.coverage.ProductLicenseChecker;
import com.atlassian.sal.api.ApplicationProperties;

/**
 * Class which checks whether the license allows changing retention file configuration
 */
public class AuditRetentionFileConfigLicenseChecker {
    private final ProductLicenseChecker productLicenseChecker;
    private final ApplicationProperties applicationProperties;

    public AuditRetentionFileConfigLicenseChecker(ProductLicenseChecker productLicenseChecker, ApplicationProperties applicationProperties) {
        this.productLicenseChecker = productLicenseChecker;
        this.applicationProperties = applicationProperties;
    }

    public boolean allowUpdate() {
        return productLicenseChecker.isDcLicenseOrExempt() ||
                ApplicationProperties.PLATFORM_BITBUCKET.equals(applicationProperties.getPlatformId());
    }

}
