package com.atlassian.audit.file;

import com.atlassian.audit.rest.model.AuditRetentionFileConfigJson;

import java.util.Objects;

public class AuditRetentionFileConfig {
    private final int maxFileCount;
    private final long maxFileSizeB;

    public AuditRetentionFileConfig(int maxFileCount, long maxFileSize) {
        this.maxFileCount = maxFileCount;
        this.maxFileSizeB = maxFileSize * 1024 * 1024;
    }

    public int getMaxFileCount() {
        return maxFileCount;
    }

    public long getMaxFileSizeB() {
        return maxFileSizeB;
    }

    public AuditRetentionFileConfigJson toJson() {
        return new AuditRetentionFileConfigJson(this.getMaxFileCount());
    }

    public static AuditRetentionFileConfig fromJson(AuditRetentionFileConfigJson configJson, long maxFileSize) {
        return new AuditRetentionFileConfig(configJson.getMaxFileCount(), maxFileSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuditRetentionFileConfig that = (AuditRetentionFileConfig) o;
        return maxFileCount == that.maxFileCount;
    }

    @Override
    public int hashCode() {
        return Objects.hash(maxFileCount);
    }

}
