package com.atlassian.audit.csv;

import com.atlassian.audit.coverage.ProductLicenseChecker;
import com.atlassian.sal.api.ApplicationProperties;

/**
 * Class which checks whether the license allows for selective exporting of csv files
 */
public class SelectiveExportLicenseChecker {
    private final ProductLicenseChecker productLicenseChecker;
    private final ApplicationProperties applicationProperties;

    public SelectiveExportLicenseChecker(ProductLicenseChecker productLicenseChecker, ApplicationProperties applicationProperties) {
        this.productLicenseChecker = productLicenseChecker;
        this.applicationProperties = applicationProperties;
    }

    public boolean allowSelectiveExport() {
        return productLicenseChecker.isDcLicenseOrExempt() ||
                ApplicationProperties.PLATFORM_CONFLUENCE.equals(applicationProperties.getPlatformId());
    }

}
