package com.atlassian.audit.csv;

import com.atlassian.audit.api.AuditQuery;
import com.atlassian.audit.api.AuditSearchService;
import com.atlassian.sal.api.message.I18nResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;

import static java.util.Objects.requireNonNull;

// Searches database and writes to csv
public class AuditCsvExporter {
    private static final Logger log = LoggerFactory.getLogger(AuditCsvExporter.class);
    private final AuditSearchService searchService;
    private final AuditQuery query;
    private final I18nResolver resolver;

    public AuditCsvExporter(AuditSearchService searchService, AuditQuery query, I18nResolver resolver) {
        this.searchService = searchService;
        this.query = query;
        this.resolver = resolver;
    }

    /**
     * Searches database for audit entities and writes this parsed data to the {@link OutputStream} in the form of a csv
     *
     * @param stream OutputStream to write to
     * @param offset number of Audit Entities to skip
     * @param limit  maximum number of Audit Entities to produce
     */
    public void export(@Nonnull OutputStream stream, int offset, int limit) {
        requireNonNull(stream, "stream");
        try (AuditCsvWriter writer = new AuditCsvWriter(resolver, stream)) {
            writer.appendHeader();
            searchService.stream(query, offset, limit, writer::appendRow);
        } catch (TimeoutException e) {
            log.error("Failed to write Audit Log to a CSV because it took too long", e);
        } catch (IOException e) {
            log.error("Failed to close mapWriter", e);
        }
    }
}
