package com.atlassian.audit.coverage;

import com.atlassian.audit.entity.AuditCoverageConfig;
import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.plugins.rest.common.security.AuthorisationException;

/**
 * A delegate which fails if the user doesn't have permission to view / update coverage configuration.
 */
public class RestrictiveCoverageConfigService implements InternalAuditCoverageConfigService {

    private final PermissionChecker permissionChecker;

    private final InternalAuditCoverageConfigService origin;

    public RestrictiveCoverageConfigService(PermissionChecker permissionChecker, InternalAuditCoverageConfigService origin) {
        this.permissionChecker = permissionChecker;
        this.origin = origin;
    }

    @Override
    public AuditCoverageConfig getConfig() {
        if (!permissionChecker.hasCoverageConfigViewPermission()) {
            throw new AuthorisationException("The user is not allowed to view audit coverage configuration");
        }
        return origin.getConfig();
    }

    @Override
    public void updateConfig(AuditCoverageConfig config) {
        if (!permissionChecker.hasCoverageConfigUpdatePermission()) {
            throw new AuthorisationException("The user is not allowed to update audit coverage configuration");
        }
        origin.updateConfig(config);
    }
}
