package com.atlassian.audit.broker;

import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.entity.AuditEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

import static java.util.Objects.requireNonNull;

public class LoggingRejectionHandler implements AuditEntityRejectionHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(LoggingRejectionHandler.class);

    private final Logger log;

    public LoggingRejectionHandler(Logger log) {
        this.log = requireNonNull(log);
    }

    @Override
    public void reject(InternalAuditBroker broker, AuditConsumer consumer, List<AuditEntity> batch) {
        log.warn(String.format("%d events have been discarded from %s queue", batch.size(), consumer.getClass().getSimpleName()));
    }
}
