package com.atlassian.audit.broker;

import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.entity.AuditEntity;

import javax.annotation.Nonnull;

/**
 * A component to be used to dispatch {@link AuditEntity} to {@link AuditConsumer}.
 * Changes to this interface will probably require corresponding change to {@code AuditBroker}.
 * This interface shouldn't be exposed to the plugin, everybody should use {@link com.atlassian.audit.api.AuditService}
 */

public interface InternalAuditBroker {

    /**
     * Dispatch the input entity to {@link AuditConsumer} according to current settings
     *
     * @param entity to be dispatched
     */
    void audit(@Nonnull AuditEntity entity);
}
