package com.atlassian.audit.broker;

import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.entity.AuditEntity;

import javax.annotation.Nonnull;

/**
 * Discards or passes each AuditEntity before reaching {@link AuditConsumer}
 * <p>
 * E.g.
 * Discards an AuditEntity if it's invalid with product License.
 */
public interface AuditPolicy {

    /**
     * @param entity to be evaluated
     * @return true if the entity should be sent to {@link AuditConsumer}
     */
    boolean pass(@Nonnull AuditEntity entity);

}
