package com.atlassian.audit.ao.service;

import com.atlassian.audit.ao.dao.AuditEntityDao;
import com.atlassian.audit.api.AuditEntityCursor;
import com.atlassian.audit.api.AuditQuery;
import com.atlassian.audit.api.AuditSearchService;
import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditEntity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import java.util.function.Consumer;

import static java.util.Objects.requireNonNull;

public class DatabaseAuditSearchService implements AuditSearchService {

    private static final int MAX_LIMIT = 10000;
    private final AuditEntityDao dao;

    public DatabaseAuditSearchService(AuditEntityDao dao) {
        this.dao = dao;
    }

    @Nonnull
    @Override
    public Page<AuditEntity, AuditEntityCursor> findBy(@Nonnull AuditQuery query,
                                                       @Nonnull PageRequest<AuditEntityCursor> pageRequest,
                                                       int scanLimit) {
        requireNonNull(query, "query");
        requireNonNull(pageRequest, "pageRequest");
        if (pageRequest.getLimit() > MAX_LIMIT) {
            throw new IllegalArgumentException("Maximum allowed page size is " + MAX_LIMIT);
        }
        if (scanLimit == Integer.MAX_VALUE) {
            return dao.findBy(query, pageRequest);
        } else {
            return dao.findBy(query, pageRequest, scanLimit);
        }
    }

    @Override
    public void stream(@Nonnull AuditQuery query, int offset, int limit, @Nonnull Consumer<AuditEntity> consumer) {
        requireNonNull(query, "query");
        requireNonNull(consumer, "consumer");
        dao.stream(query, consumer, offset, limit);
    }

    @Override
    public long count(@Nullable AuditQuery query) {
        if (query == null) {
            return dao.count();
        }
        return dao.count(query);
    }
}

