package com.atlassian.audit.ao.service;

import com.atlassian.audit.ao.dao.AuditEntityDao;
import com.atlassian.audit.coverage.SingleValueCache;

import static java.util.concurrent.TimeUnit.MINUTES;

/**
 * Cache the total count of events in DB to reduce the count() call to Database.
 */
public class CachedCountService {

    private final AuditEntityDao dao;

    private final SingleValueCache<Long> countCache;

    public CachedCountService(AuditEntityDao dao, int cacheExpirationInMinutes) {
        this.dao = dao;
        countCache = new SingleValueCache<>(this::getCountFromDatabase, cacheExpirationInMinutes, MINUTES);
    }

    /**
     *
     * To avoid potential performance impact, database total count query is only triggered if current cache expires.
     */
    public long count() {
        return countCache.get();
    }

    private long getCountFromDatabase() {
        return dao.count();
    }

}
