package com.atlassian.audit.ao.dao.entity;

import net.java.ao.Accessor;
import net.java.ao.Preload;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Index;
import net.java.ao.schema.Indexes;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;

@Table(AoAuditEntity.TABLE_NAME)
@Preload
@Indexes({
        @Index(name = "timestampAndId", methodNames = {"getTimestamp", "getId"}),
        @Index(name = "userIdAndTimestamp", methodNames = {"getUserId", "getTimestamp"}),
        @Index(name = "primaryResourceAndTimestamp", methodNames = {"getPrimaryResourceId", "getPrimaryResourceType", "getTimestamp"}),
        @Index(name = "secondaryResourceAndTimestamp", methodNames = {"getSecondaryResourceId", "getSecondaryResourceType", "getTimestamp"}),
        @Index(name = "thirdResourceAndTimestamp", methodNames = {"getResourceId3", "getResourceType3", "getTimestamp"}),
        @Index(name = "fourthResourceAndTimestamp", methodNames = {"getResourceId4", "getResourceType4", "getTimestamp"}),
        @Index(name = "fifthResourceAndTimestamp", methodNames = {"getResourceId5", "getResourceType5", "getTimestamp"}),
        @Index(name = "category", methodNames = {"getCategory"}),
        @Index(name = "action", methodNames = {"getAction"}),
})
public interface AoAuditEntity extends RawEntity<Integer> {

    String TABLE_NAME = "AUDIT_ENTITY";
    String ACTION_COLUMN = "ACTION";
    String ACTION_TKEY_COLUMN = "ACTION_T_KEY";
    String CATEGORY_COLUMN = "CATEGORY";
    String CATEGORY_TKEY_COLUMN = "CATEGORY_T_KEY";
    String LEVEL_COLUMN = "LEVEL";
    String AREA_COLUMN = "AREA";
    String TIMESTAMP_COLUMN = "ENTITY_TIMESTAMP";
    String ID_COLUMN = "ID";
    String METHOD_COLUMN = "METHOD";
    String SOURCE_COLUMN = "SOURCE";
    String USER_ID_COLUMN = "USER_ID";
    String USER_NAME_COLUMN = "USER_NAME";
    String USER_TYPE_COLUMN = "USER_TYPE";
    String CHANGE_VALUES_COLUMN = "CHANGE_VALUES";
    String ATTRIBUTES_COLUMN = "ATTRIBUTES";
    String RESOURCES_COLUMN = "RESOURCES";
    String SEARCH_STRING_COLUMN = "SEARCH_STRING";
    String SYSTEM_COLUMN = "SYSTEM_INFO";
    String NODE_COLUMN = "NODE";

    String RESOURCE_ID_COLUMN_1 = "PRIMARY_RESOURCE_ID";
    String RESOURCE_TYPE_COLUMN_1 = "PRIMARY_RESOURCE_TYPE";
    String RESOURCE_ID_COLUMN_2 = "SECONDARY_RESOURCE_ID";
    String RESOURCE_TYPE_COLUMN_2 = "SECONDARY_RESOURCE_TYPE";
    String RESOURCE_ID_COLUMN_3 = "RESOURCE_ID_3";
    String RESOURCE_TYPE_COLUMN_3 = "RESOURCE_TYPE_3";
    String RESOURCE_ID_COLUMN_4 = "RESOURCE_ID_4";
    String RESOURCE_TYPE_COLUMN_4 = "RESOURCE_TYPE_4";
    String RESOURCE_ID_COLUMN_5 = "RESOURCE_ID_5";
    String RESOURCE_TYPE_COLUMN_5 = "RESOURCE_TYPE_5";

    @AutoIncrement
    @NotNull
    @PrimaryKey(ID_COLUMN)
    Long getId();

    @NotNull
    @Accessor(ACTION_COLUMN)
    String getAction();

    @Accessor(ACTION_TKEY_COLUMN)
    String getActionI18nKey();

    @NotNull
    @Accessor(LEVEL_COLUMN)
    String getLevel();

    @NotNull
    @Accessor(AREA_COLUMN)
    String getArea();

    @Accessor(RESOURCES_COLUMN)
    @StringLength(value = StringLength.UNLIMITED)
    String getResources();

    @Accessor(CHANGE_VALUES_COLUMN)
    @StringLength(value = StringLength.UNLIMITED)
    String getChangedValues();

    @Accessor(ATTRIBUTES_COLUMN)
    @StringLength(value = StringLength.UNLIMITED)
    String getAttributes();

    @Accessor(SOURCE_COLUMN)
    String getSource();

    @NotNull
    @Accessor(TIMESTAMP_COLUMN)
    Long getTimestamp();

    @Accessor(USER_ID_COLUMN)
    String getUserId();

    @Accessor(USER_NAME_COLUMN)
    String getUsername();

    @Accessor(USER_TYPE_COLUMN)
    String getUserType();

    @Accessor(METHOD_COLUMN)
    String getMethod();

    @Accessor(CATEGORY_COLUMN)
    String getCategory();

    @Accessor(CATEGORY_TKEY_COLUMN)
    String getCategoryI18nKey();

    @Accessor(RESOURCE_ID_COLUMN_1)
    String getPrimaryResourceId();

    @Accessor(RESOURCE_TYPE_COLUMN_1)
    String getPrimaryResourceType();

    @Accessor(RESOURCE_ID_COLUMN_2)
    String getSecondaryResourceId();

    @Accessor(RESOURCE_TYPE_COLUMN_2)
    String getSecondaryResourceType();

    @Accessor(RESOURCE_ID_COLUMN_3)
    String getResourceId3();

    @Accessor(RESOURCE_TYPE_COLUMN_3)
    String getResourceType3();

    @Accessor(RESOURCE_ID_COLUMN_4)
    String getResourceId4();

    @Accessor(RESOURCE_TYPE_COLUMN_4)
    String getResourceType4();

    @Accessor(RESOURCE_ID_COLUMN_5)
    String getResourceId5();

    @Accessor(RESOURCE_TYPE_COLUMN_5)
    String getResourceType5();

    @Accessor(SEARCH_STRING_COLUMN)
    @StringLength(value = StringLength.UNLIMITED)
    String getSearchString();

    @Accessor(SYSTEM_COLUMN)
    String getSystem();

    @Accessor(NODE_COLUMN)
    String getNode();
}
