package com.atlassian.audit.ao.dao;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;

import java.util.Locale;

public class SearchTokenizer {

    final ImmutableSet.Builder<String> tokens = ImmutableSet.builder();

    SearchTokenizer put(String stringToTokenize) {
        if (stringToTokenize != null) {
            Splitter.on(" ").omitEmptyStrings().split(stringToTokenize)
                    .forEach(input -> tokens.add(input.toLowerCase(Locale.ROOT)));
        }
        return this;
    }

    String getTokenizedString() {
        return Joiner.on(" ").join(getTokens());
    }

    ImmutableSet<String> getTokens() {
        return tokens.build();
    }
}
