package com.atlassian.audit.ao.consumer;

import com.atlassian.audit.ao.dao.AuditEntityDao;
import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.spi.feature.DatabaseAuditingFeature;

import javax.annotation.Nonnull;
import java.util.List;

import static java.util.Objects.requireNonNull;

public class DatabaseAuditConsumer implements AuditConsumer {

    private final AuditEntityDao auditEntityDao;
    private final DatabaseAuditingFeature databaseAuditingFeature;

    public DatabaseAuditConsumer(DatabaseAuditingFeature databaseAuditingFeature,
                                 AuditEntityDao auditEntityDao) {
        this.databaseAuditingFeature = databaseAuditingFeature;
        this.auditEntityDao = auditEntityDao;
    }

    @Override
    public void accept(@Nonnull List<AuditEntity> entities) {
        auditEntityDao.save(requireNonNull(entities, "entities"));
    }

    @Override
    public boolean isEnabled() {
        return databaseAuditingFeature.isEnabled();
    }
}
