package com.atlassian.audit.analytics;

import com.atlassian.analytics.api.annotations.EventName;

@EventName("audit.retention.updated")
public class RetentionUpdatedEvent extends BaseAnalyticEvent{
    private final String oldRetention;
    private final String oldRetentionUnit;
    private final String newRetention;
    private final String newRetentionUnit;

    public RetentionUpdatedEvent(String oldRetention, String oldRetentionUnit, String newRetention, String newRetentionUnit, String pluginVersion) {
        super(pluginVersion);
        this.oldRetention = oldRetention;
        this.oldRetentionUnit = oldRetentionUnit;
        this.newRetention = newRetention;
        this.newRetentionUnit = newRetentionUnit;
    }

    public String getOldRetention() {
        return oldRetention;
    }

    public String getOldRetentionUnit() {
        return oldRetentionUnit;
    }

    public String getNewRetention() {
        return newRetention;
    }

    public String getNewRetentionUnit() {
        return newRetentionUnit;
    }
}
