package com.atlassian.audit.analytics;

import com.atlassian.analytics.api.annotations.EventName;

@EventName("audit.level.updated")
public class LevelUpdatedEvent extends BaseAnalyticEvent{
    private final String area;
    private final String oldLevel;
    private final String newLevel;

    public LevelUpdatedEvent(String area, String oldLevel, String newLevel, String pluginVersion) {
        super(pluginVersion);
        this.area = area;
        this.oldLevel = oldLevel;
        this.newLevel = newLevel;
    }

    public String getArea() {
        return area;
    }

    public String getOldLevel() {
        return oldLevel;
    }

    public String getNewLevel() {
        return newLevel;
    }
}
