package com.atlassian.audit.analytics;

import com.atlassian.analytics.api.annotations.EventName;

@EventName("audit.export")
public class ExportEvent extends BaseAnalyticEvent {
    private final boolean selective;
    private final String delegatedType;

    public ExportEvent(boolean selective, String delegatedType, String pluginVersion) {
        super(pluginVersion);
        this.delegatedType = delegatedType;
        this.selective = selective;
    }

    public boolean isSelective() {
        return selective;
    }

    public String getDelegatedType() {
        return delegatedType;
    }
}
