package com.atlassian.audit.analytics;

import com.atlassian.analytics.api.annotations.EventName;

@EventName("audit.events.discarded")
public class DiscardEvent extends BaseAnalyticEvent{

    private final int numberOfEvents;

    private final String source;

    public DiscardEvent(int numberOfEvents, String source, String pluginVersion) {
        super(pluginVersion);
        this.numberOfEvents = numberOfEvents;
        this.source = source;
    }

    public int getNumberOfEvents() {
        return numberOfEvents;
    }

    public String getSource() {
        return source;
    }
}
