/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.entity;

import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AuditType {
    private final CoverageArea area;
    private final String category;
    private final String action;
    private final CoverageLevel level;

    public AuditType(@Nonnull CoverageArea area, @Nonnull String category, @Nonnull String action, @Nonnull CoverageLevel level) {
        this.area = Objects.requireNonNull(area);
        this.category = Objects.requireNonNull(category);
        this.action = Objects.requireNonNull(action);
        this.level = Objects.requireNonNull(level);
    }

    @Nonnull
    public CoverageArea getArea() {
        return this.area;
    }

    @Nonnull
    public String getCategory() {
        return this.category;
    }

    @Nonnull
    public String getAction() {
        return this.action;
    }

    @Nonnull
    public CoverageLevel getLevel() {
        return this.level;
    }

    public String toString() {
        return "AuditType{area=" + (Object)((Object)this.area) + ", category='" + this.category + '\'' + ", action='" + this.action + '\'' + ", level=" + (Object)((Object)this.level) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditType auditType = (AuditType)o;
        return this.area == auditType.area && this.category.equals(auditType.category) && this.action.equals(auditType.action) && this.level == auditType.level;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.area, this.category, this.action, this.level});
    }
}

