/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.api;

import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditQuery {
    private final Set<String> actions;
    private final Set<String> categories;
    private final Instant from;
    private final Instant to;
    private final String resourceId;
    private final String resourceType;
    private final Set<String> userIds;
    private final String searchText;
    private final Long minId;
    private final Long maxId;

    private AuditQuery(Builder builder) {
        this.actions = builder.actions;
        this.categories = builder.categories;
        this.from = builder.from;
        this.to = builder.to;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.userIds = builder.userIds;
        this.searchText = builder.searchText;
        this.minId = builder.minId;
        this.maxId = builder.maxId;
    }

    @Nonnull
    public Set<String> getActions() {
        return this.actions;
    }

    @Nonnull
    public Set<String> getCategories() {
        return this.categories;
    }

    @Nonnull
    public Optional<Instant> getFrom() {
        return Optional.ofNullable(this.from);
    }

    @Nonnull
    public Optional<Instant> getTo() {
        return Optional.ofNullable(this.to);
    }

    @Nonnull
    public Optional<String> getResourceId() {
        return Optional.ofNullable(this.resourceId);
    }

    @Nonnull
    public Optional<String> getResourceType() {
        return Optional.ofNullable(this.resourceType);
    }

    @Nonnull
    public Set<String> getUserIds() {
        return this.userIds;
    }

    @Nonnull
    public Optional<String> getSearchText() {
        return Optional.ofNullable(this.searchText);
    }

    @Nonnull
    public Optional<Long> getMinId() {
        return Optional.ofNullable(this.minId);
    }

    @Nonnull
    public Optional<Long> getMaxId() {
        return Optional.ofNullable(this.maxId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AuditQuery query) {
        return new Builder(query);
    }

    public boolean hasFilter() {
        return !this.getActions().isEmpty() || !this.getCategories().isEmpty() || this.getFrom().isPresent() || this.getTo().isPresent() || this.getResourceType().isPresent() || this.getResourceId().isPresent() || !this.getUserIds().isEmpty() || this.getSearchText().isPresent();
    }

    public static class Builder {
        private Set<String> actions = new HashSet<String>();
        private Set<String> categories = new HashSet<String>();
        private String resourceId;
        private String resourceType;
        private Set<String> userIds = new HashSet<String>();
        private Instant from;
        private Instant to;
        private String searchText;
        private Long minId;
        private Long maxId;

        private Builder() {
        }

        private Builder(AuditQuery query) {
            this.actions = query.getActions();
            this.categories = query.getCategories();
            this.resourceId = query.getResourceId().orElse(null);
            this.resourceType = query.getResourceType().orElse(null);
            this.userIds = query.getUserIds();
            this.from = query.getFrom().orElse(null);
            this.to = query.getTo().orElse(null);
            this.searchText = query.getSearchText().orElse(null);
            this.minId = query.getMinId().orElse(null);
            this.maxId = query.getMaxId().orElse(null);
        }

        public Builder actions(String ... actions) {
            if (actions != null && actions.length > 0) {
                this.actions = new HashSet<String>(Arrays.asList(actions));
            }
            return this;
        }

        public Builder from(@Nullable Instant from) {
            this.from = from;
            return this;
        }

        public Builder to(@Nullable Instant to) {
            this.to = to;
            return this;
        }

        public Builder categories(String ... categories) {
            if (categories != null && categories.length > 0) {
                this.categories = new HashSet<String>(Arrays.asList(categories));
            }
            return this;
        }

        public Builder resource(@Nonnull String type, @Nonnull String id) {
            this.resourceType = Objects.requireNonNull(type, "type");
            this.resourceId = Objects.requireNonNull(id, "id");
            return this;
        }

        public Builder userIds(String ... userIds) {
            if (userIds != null && userIds.length > 0) {
                this.userIds = new HashSet<String>(Arrays.asList(userIds));
            }
            return this;
        }

        public Builder searchText(@Nullable String searchText) {
            this.searchText = searchText;
            return this;
        }

        public Builder minId(@Nonnull Long minId) {
            this.minId = Objects.requireNonNull(minId, "minId");
            return this;
        }

        public Builder maxId(@Nonnull Long maxId) {
            this.maxId = Objects.requireNonNull(maxId, "maxId");
            return this;
        }

        public AuditQuery build() {
            return new AuditQuery(this);
        }
    }
}

