package com.atlassian.audit.api;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.audit.entity.AuditEntity;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * SPI receives each AuditEntity for further consumption.
 * <p>
 * Examples:
 * <ul>
 * <li>outputs entities to a relational database, for other components to query</li>
 * <li>outputs entities to a file in a format consumable by an ELK stack</li>
 * </ul>
 */
@ExperimentalSpi
public interface AuditConsumer {
    /***
     * @param entities list of entities
     */
    void accept(@Nonnull List<AuditEntity> entities);

    /**
     * @return if this consumer is enabled or disabled. If disabled, {{@link #accept(List)} method will not be called
     */
    default boolean isEnabled() {
        return true;
    }
}
