(window["atlassianWebpackJsonp705e76b66ce3812676d38b6caf78104b"] = window["atlassianWebpackJsonp705e76b66ce3812676d38b6caf78104b"] || []).push([[0],{

/***/ 122:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getPermissionsResponse = getPermissionsResponse;
exports.getAnonymousProjectsResponse = getAnonymousProjectsResponse;
exports.getProjectsResponse = getProjectsResponse;
exports.createReciproticalLink = createReciproticalLink;
exports.canDeleteEntityLinkResponse = canDeleteEntityLinkResponse;
exports.deleteEntityLink = deleteEntityLink;
exports.makeEntityLinkPrimary = makeEntityLinkPrimary;
exports.getEntityLinks = getEntityLinks;
function getPermissionsResponse(selectedApplink) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/permission/reciprocate-entity-create/' + selectedApplink + '.json', {
        headers: { 'Content-Type': 'application/json' },
        credentials: 'same-origin'
    });
}

function getAnonymousProjectsResponse(selectedApplink) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/entities/anonymous/' + selectedApplink + '.json', {
        headers: { 'Content-Type': 'application/json' },
        credentials: 'same-origin'
    });
}

function getProjectsResponse(selectedApplink) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/entities/' + selectedApplink + '.json', {
        headers: { 'Content-Type': 'application/json' },
        credentials: 'same-origin'
    });
}

function createReciproticalLink(entityLink, projectKey, type, twoway) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/entitylink/' + type + '/' + projectKey + '.json?reciprocate=' + twoway, {
        headers: { 'Content-Type': 'application/json; charset=UTF-8' },
        method: 'PUT',
        body: JSON.stringify(entityLink),
        credentials: 'same-origin'
    });
}

function canDeleteEntityLinkResponse(entityLink, type, projectKey) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/permission/reciprocate-entity-delete/' + entityLink.applicationId + '/' + type + '/' + projectKey + '/' + entityLink.typeId + '/' + entityLink.key + '.json', {
        headers: { 'Content-Type': 'application/json' },
        credentials: 'same-origin'
    });
}

function deleteEntityLink(entityLink, type, projectKey, twoway) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/entitylink/' + type + '/' + projectKey + '?typeId=' + entityLink.typeId + '&key=' + entityLink.key + '&applicationId=' + entityLink.applicationId + '&reciprocate=' + twoway, {
        method: 'DELETE',
        headers: { 'Content-Type': 'application/json' },
        credentials: 'same-origin'
    });
}

function makeEntityLinkPrimary(entityLink, type, projectKey) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/entitylink/primary/' + type + '/' + projectKey + '?typeId=' + entityLink.typeId + '&key=' + entityLink.key + '&applicationId=' + entityLink.applicationId, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        credentials: 'same-origin'
    });
}

function getEntityLinks(type, projectKey) {
    return fetch(WRM.contextPath() + '/rest/applinks/1.0/entitylink/list/' + type + '/' + projectKey + '.json', {
        headers: { 'Content-Type': 'application/json' },
        credentials: 'same-origin'
    });
}

var PermissionCode = exports.PermissionCode = {
    NO_AUTHENTICATION: 'NO_AUTHENTICATION',
    NO_PERMISSION: 'NO_PERMISSION',
    MISSING: 'MISSING',
    NO_AUTHENTICATION_CONFIGURED: 'NO_AUTHENTICATION_CONFIGURED',
    NO_CONNECTION: 'NO_CONNECTION',
    CREDENTIALS_REQUIRED: 'CREDENTIALS_REQUIRED',
    AUTHENTICATION_FAILED: 'AUTHENTICATION_FAILED',
    ALLOWED: 'ALLOWED'
};

/***/ }),

/***/ 159:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _emptyState = __webpack_require__(355);

var _emptyState2 = _interopRequireDefault(_emptyState);

var _integration = __webpack_require__(269);

var _integration2 = _interopRequireDefault(_integration);

var _buildingFunctionality = __webpack_require__(270);

var _buildingFunctionality2 = _interopRequireDefault(_buildingFunctionality);

var _button = __webpack_require__(66);

var _button2 = _interopRequireDefault(_button);

var _wrmReactI18n = __webpack_require__(74);

var _entitylinksTable = __webpack_require__(273);

var _entitylinksTable2 = _interopRequireDefault(_entitylinksTable);

__webpack_require__(342);

var _modalDialog = __webpack_require__(123);

var _flag = __webpack_require__(352);

var _createEntityLinkDialog = __webpack_require__(344);

var _createEntityLinkDialog2 = _interopRequireDefault(_createEntityLinkDialog);

var _EntitylinksRest = __webpack_require__(122);

var _theme = __webpack_require__(10);

var _checkCircle = __webpack_require__(348);

var _checkCircle2 = _interopRequireDefault(_checkCircle);

var _helpPaths = __webpack_require__(349);

var helpPaths = _interopRequireWildcard(_helpPaths);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Title = _react2.default.createElement(
    'h1',
    { className: 'page-title' },
    "Project links"
);

var FlagStatus = {
    HIDDEN: 'hidden',
    ENTITY_DELETED: 'entity_deleted',
    ENTITY_CREATED: 'entity_created'
};

var getSuccessFlag = function getSuccessFlag(description) {
    return _react2.default.createElement(_flag.AutoDismissFlag, {
        icon: _react2.default.createElement(_checkCircle2.default, {
            primaryColor: _theme.colors.G300,
            label: "Success"
        }),
        description: description,
        title: "Success"
    });
};

var EntityLinks = function (_Component) {
    _inherits(EntityLinks, _Component);

    function EntityLinks(props) {
        _classCallCheck(this, EntityLinks);

        var _this = _possibleConstructorReturn(this, (EntityLinks.__proto__ || Object.getPrototypeOf(EntityLinks)).call(this, props));

        _this.deleteEntityLink = function (entityLink) {
            (0, _EntitylinksRest.getEntityLinks)(_this.props.type, _this.props.projectKey).then(function (response) {
                return response.json();
            }).then(function (data) {
                _this.setState({
                    entityLinks: data.entity,
                    shownFlag: {
                        status: FlagStatus.ENTITY_DELETED,
                        projectName: entityLink.name
                    }
                });
            }).catch(function (e) {
                console.error('Unable to load the entityLinks in the background ' + e);
            });

            //Temporary delete this link until we get the updated response from the server where the link is deleted
            // and primaries are recalculated.
            var filteredEntityLinks = _this.state.entityLinks.filter(function (link) {
                return !(entityLink.key === link.key && entityLink.applicationId === link.applicationId);
            });
            _this.setState({
                entityLinks: filteredEntityLinks
            });
        };

        _this.makePrimaryEntityLink = function (entityLink) {
            var entityLinks = _this.state.entityLinks;
            entityLinks.map(function (link) {
                if (entityLink.typeId === link.typeId) {
                    link.isPrimary = entityLink === link;
                }
            });
            _this.setState({ entityLinks: entityLinks });
        };

        _this.state = {
            entityLinks: _this.props.entityLinks,
            isDialogOpen: false,
            shownFlag: null
        };
        return _this;
    }

    _createClass(EntityLinks, [{
        key: 'addEntityLink',
        value: function addEntityLink(link) {
            this.setState(function (prevState) {
                return {
                    entityLinks: [].concat(_toConsumableArray(prevState.entityLinks), [link]),
                    shownFlag: {
                        status: FlagStatus.ENTITY_CREATED,
                        projectName: link.name
                    }
                };
            });
        }
    }, {
        key: 'createButton',
        value: function createButton(appearance) {
            var _this2 = this;

            return _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    _button2.default,
                    {
                        className: 'add-link',
                        onClick: function onClick() {
                            return _this2.setState({ isDialogOpen: true });
                        },
                        appearance: appearance
                    },
                    "Create project link"
                ),
                _react2.default.createElement(
                    _modalDialog.ModalTransition,
                    null,
                    this.state.isDialogOpen && _react2.default.createElement(_createEntityLinkDialog2.default, _extends({}, this.props, {
                        entityLinks: this.state.entityLinks,
                        onEntityAdded: function onEntityAdded(link) {
                            return _this2.addEntityLink(link);
                        },
                        onClose: function onClose() {
                            return _this2.setState({ isDialogOpen: false });
                        }
                    }))
                )
            );
        }
    }, {
        key: 'createFlag',
        value: function createFlag() {
            var _this3 = this;

            var message = void 0;

            if (!this.state.shownFlag) {
                return;
            } else if (this.state.shownFlag.status === FlagStatus.ENTITY_CREATED) {
                message = _wrmReactI18n.format("You''ve successfully created a project link to {0}", this.state.shownFlag.projectName);
            } else if (this.state.shownFlag.status === FlagStatus.ENTITY_DELETED) {
                message = _wrmReactI18n.format("You''ve successfully deleted a project link to {0}", this.state.shownFlag.projectName);
            }

            return _react2.default.createElement(
                _flag.FlagGroup,
                { onDismissed: function onDismissed() {
                        return _this3.setState({ shownFlag: null });
                    } },
                getSuccessFlag(message)
            );
        }
    }, {
        key: 'onHelpButtonClicked',
        value: function onHelpButtonClicked() {
            var url = helpPaths.getFullPath('applinks.docs.adding.project.link');
            window.open(url, '_blank');
        }
    }, {
        key: 'onApplinksLearnMoreClicked',
        value: function onApplinksLearnMoreClicked() {
            var url = helpPaths.getFullPath('applinks.docs.adding.application.link');
            window.open(url, '_blank');
        }
    }, {
        key: 'render',
        value: function render() {
            var _this4 = this;

            var entityLinks = this.state.entityLinks;
            var type = this.props.type;


            var noApplinksEmptyState = _react2.default.createElement(
                'div',
                { className: 'no-app-links-empty-state' },
                Title,
                _react2.default.createElement(_emptyState2.default, {
                    header: "Get your tools talking",
                    description: "Before you can link projects across Atlassian applications you need to link the applications themselves.",
                    maxImageWidth: 240,
                    maxImageHeight: 240,
                    imageUrl: _buildingFunctionality2.default,
                    tertiaryAction: _react2.default.createElement(
                        _button2.default,
                        { appearance: 'link', onClick: function onClick() {
                                return _this4.onApplinksLearnMoreClicked();
                            } },
                        "Learn about Application Links"
                    )
                })
            );

            var noEntityLinksEmptyState = _react2.default.createElement(
                'div',
                { className: 'no-links-empty-state' },
                Title,
                _react2.default.createElement(_emptyState2.default, {
                    header: "Better integrate your projects",
                    description: "Connect your Jira, Bitbucket and Confluence projects and space together for a smarter integration and connection.",
                    maxImageWidth: 480,
                    maxImageHeight: 480,
                    imageUrl: _integration2.default,
                    primaryAction: this.createButton('primary'),
                    tertiaryAction: _react2.default.createElement(
                        _button2.default,
                        { appearance: 'subtle-link', onClick: function onClick() {
                                return _this4.onHelpButtonClicked();
                            } },
                        "Learn more"
                    )
                })
            );

            if (this.props.applicationLinks.length === 0) {
                return noApplinksEmptyState;
            } else if (entityLinks.length === 0) {
                return noEntityLinksEmptyState;
            } else {
                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    this.createFlag(),
                    _react2.default.createElement(
                        'div',
                        { className: 'top-container' },
                        Title,
                        _react2.default.createElement(
                            'div',
                            { className: 'button-container' },
                            this.createButton('default')
                        )
                    ),
                    _react2.default.createElement(
                        'p',
                        { className: 'explanation-container' },
                        "Link projects to improve your integration experience between different applications.",
                        ' ',
                        _react2.default.createElement(
                            'a',
                            {
                                href: helpPaths.getFullPath('applinks.docs.adding.project.link'),
                                target: '_blank' },
                            "Learn more"
                        )
                    ),
                    _react2.default.createElement(_entitylinksTable2.default, {
                        currentApp: this.props.currentApp,
                        projectKey: this.props.projectKey,
                        type: type,
                        entityLinks: entityLinks,
                        onDelete: this.deleteEntityLink,
                        onMakePrimary: this.makePrimaryEntityLink,
                        applicationLinks: this.props.applicationLinks
                    })
                );
            }
        }
    }]);

    return EntityLinks;
}(_react.Component);

exports.default = EntityLinks;

/***/ }),

/***/ 181:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.authorize = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _wrmReactI18n = __webpack_require__(74);

var _button = __webpack_require__(66);

var _button2 = _interopRequireDefault(_button);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var windowName = 'com_atlassian_applinks_authentication';

function _authorize(url, callback) {
    var authWindow = void 0;
    window.oauthCallback = {
        success: function success() {
            console.log('sucessfully authenticated');
            if (callback) {
                callback();
            }
            authWindow.close();
        }
    };
    authWindow = window.open(url, windowName);
}

exports.authorize = _authorize;

var AuthButton = function (_Component) {
    _inherits(AuthButton, _Component);

    function AuthButton() {
        _classCallCheck(this, AuthButton);

        return _possibleConstructorReturn(this, (AuthButton.__proto__ || Object.getPrototypeOf(AuthButton)).apply(this, arguments));
    }

    _createClass(AuthButton, [{
        key: 'authorize',
        value: function authorize() {
            return _authorize(this.props.url, this.props.successCallback);
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            return _react2.default.createElement(
                _button2.default,
                { appearance: 'primary', className: 'auth-button', onClick: function onClick(e) {
                        return _this2.authorize();
                    } },
                _wrmReactI18n.format("Authorize", this.props.currentApp)
            );
        }
    }]);

    return AuthButton;
}(_react.Component);

exports.default = AuthButton;

/***/ }),

/***/ 243:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _entityLinksManage = __webpack_require__(249);

var _whenDomReady = __webpack_require__(350);

var _whenDomReady2 = _interopRequireDefault(_whenDomReady);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _whenDomReady2.default)().then(function () {
    var renderElement = document.getElementById('entity-links-container');
    var data = [];
    try {
        data = JSON.parse(renderElement.getAttribute('data-links'));
    } catch (e) {
        console.log('cannot parse JSON');
    }

    (0, _entityLinksManage.initLinks)(renderElement, data);
});

/***/ }),

/***/ 249:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.initLinks = initLinks;

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _reactDom = __webpack_require__(43);

var _reactDom2 = _interopRequireDefault(_reactDom);

var _entityLinks = __webpack_require__(159);

var _entityLinks2 = _interopRequireDefault(_entityLinks);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function initLinks(el, data) {
    var entityLinks = data.entityLinks,
        applicationLinks = data.applicationLinks,
        currentApp = data.currentApp,
        projectKey = data.projectKey,
        type = data.type;

    _reactDom2.default.render(_react2.default.createElement(_entityLinks2.default, {
        entityLinks: entityLinks,
        applicationLinks: applicationLinks,
        currentApp: currentApp,
        projectKey: projectKey,
        type: type
    }), el);
}

/***/ }),

/***/ 269:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "0a0dd4b4dddfa6804e8f340f01cd8865.svg";

/***/ }),

/***/ 270:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "143708e0f40e54a62051936ad897afdf.svg";

/***/ }),

/***/ 272:
/***/ (function(module, exports) {

module.exports = require("wrm/format");

/***/ }),

/***/ 273:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _lozenge = __webpack_require__(357);

var _lozenge2 = _interopRequireDefault(_lozenge);

var _dynamicTable = __webpack_require__(351);

var _dynamicTable2 = _interopRequireDefault(_dynamicTable);

var _wrmReactI18n = __webpack_require__(74);

var _i18n = __webpack_require__(296);

__webpack_require__(159);

var _entitylinksTableActions = __webpack_require__(297);

var _entitylinksTableActions2 = _interopRequireDefault(_entitylinksTableActions);

var _tooltip = __webpack_require__(356);

var _tooltip2 = _interopRequireDefault(_tooltip);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EntityLinkTable = function (_Component) {
    _inherits(EntityLinkTable, _Component);

    function EntityLinkTable(props) {
        _classCallCheck(this, EntityLinkTable);

        return _possibleConstructorReturn(this, (EntityLinkTable.__proto__ || Object.getPrototypeOf(EntityLinkTable)).call(this, props));
    }

    _createClass(EntityLinkTable, [{
        key: 'createRows',
        value: function createRows(entityLinks, type, applinks) {
            var _this2 = this;

            return entityLinks.map(function (entityLink, index) {
                var applink = applinks.find(function (applink) {
                    return applink.id === entityLink.applicationId;
                });
                var outgoingApplicationName = (0, _i18n.getApplicationTypeName)(applink.type);
                return {
                    key: 'row-' + index + '-' + entityLink.applicationId + '-' + entityLink.key,
                    cells: [{
                        key: entityLink.applicationId + '-' + entityLink.key,
                        content: EntityLinkTable.projectLinksApplicationName(entityLink, applink.name, outgoingApplicationName)
                    }, {
                        key: entityLink.applicationId + '-' + entityLink.key,
                        content: EntityLinkTable.projectLinksName(entityLink.name, entityLink.isPrimary)
                    }, {
                        key: entityLink.applicationId + '-' + entityLink.key,
                        content: entityLink.key
                    }, {
                        key: entityLink.applicationId + '-' + entityLink.key,
                        content: _react2.default.createElement(_entitylinksTableActions2.default, {
                            currentApp: _this2.props.currentApp,
                            entityLink: entityLink,
                            type: type,
                            onDelete: function onDelete(entityLink) {
                                return _this2.props.onDelete(entityLink);
                            },
                            onMakePrimary: function onMakePrimary(entityLink) {
                                return _this2.props.onMakePrimary(entityLink);
                            },
                            outgoingApplicationName: outgoingApplicationName,
                            projectKey: _this2.props.projectKey
                        })
                    }]
                };
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                type = _props.type,
                entityLinks = _props.entityLinks,
                applicationLinks = _props.applicationLinks;


            return _react2.default.createElement(_dynamicTable2.default, {
                head: EntityLinkTable.createHead(),
                rows: this.createRows(entityLinks, type, applicationLinks)
            });
        }
    }], [{
        key: 'projectLinksApplicationName',
        value: function projectLinksApplicationName(entityLink, serverName, outgoingAppName) {
            return _react2.default.createElement(
                'div',
                { className: 'application-name-alignment' },
                _react2.default.createElement('img', { src: entityLink.iconUri, width: 25, height: 25 }),
                _react2.default.createElement(
                    'span',
                    { className: 'application-name-margin' },
                    serverName,
                    _react2.default.createElement(
                        'span',
                        { className: 'application-name-secondary' },
                        '(' + outgoingAppName + ')'
                    )
                )
            );
        }
    }, {
        key: 'projectLinksName',
        value: function projectLinksName(projectName, isProjectPrimary) {
            return _react2.default.createElement(
                'div',
                { className: 'name-container' },
                _react2.default.createElement(
                    'span',
                    { className: 'entity-link-name' },
                    projectName
                ),
                isProjectPrimary && _react2.default.createElement(
                    _tooltip2.default,
                    { content: "This project will be prioritised" },
                    _react2.default.createElement(
                        _lozenge2.default,
                        null,
                        "PRIMARY"
                    )
                )
            );
        }
    }, {
        key: 'calculateWidth',
        value: function calculateWidth(value, multiplier) {
            return _wrmReactI18n.I18n.getText(value).length * multiplier;
        }
    }, {
        key: 'createHead',
        value: function createHead() {
            return {
                cells: [{
                    key: 'application',
                    content: "Application",
                    width: this.calculateWidth('entitylinks.application.name.header', 0.75),
                    isSortable: true
                }, {
                    key: 'name',
                    content: "Name",
                    width: this.calculateWidth('entitylinks.project.name.header', 1.5),
                    isSortable: true
                }, {
                    key: 'key',
                    content: "Key",
                    width: this.calculateWidth('entitylinks.project.key.header', 0.75),
                    isSortable: true
                }, {
                    key: 'actions'
                }]
            };
        }
    }]);

    return EntityLinkTable;
}(_react.Component);

exports.default = EntityLinkTable;

/***/ }),

/***/ 296:
/***/ (function(module, exports) {

module.exports = require("applinks/common/i18n");

/***/ }),

/***/ 297:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _Button = __webpack_require__(149);

var _Button2 = _interopRequireDefault(_Button);

var _Droplist = __webpack_require__(354);

var _Droplist2 = _interopRequireDefault(_Droplist);

var _item = __webpack_require__(189);

var _item2 = _interopRequireDefault(_item);

var _more = __webpack_require__(301);

var _more2 = _interopRequireDefault(_more);

var _modalDialog = __webpack_require__(123);

var _wrmReactI18n = __webpack_require__(74);

var _deleteEntityLinkDialog = __webpack_require__(304);

var _deleteEntityLinkDialog2 = _interopRequireDefault(_deleteEntityLinkDialog);

var _EntitylinksRest = __webpack_require__(122);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EntityLinksMoreActions = function (_Component) {
    _inherits(EntityLinksMoreActions, _Component);

    function EntityLinksMoreActions(props) {
        _classCallCheck(this, EntityLinksMoreActions);

        var _this = _possibleConstructorReturn(this, (EntityLinksMoreActions.__proto__ || Object.getPrototypeOf(EntityLinksMoreActions)).call(this, props));

        _this.state = {
            isMoreActionsOpen: false,
            isDeleteLinkModalOpen: false
        };
        return _this;
    }

    _createClass(EntityLinksMoreActions, [{
        key: 'onClickMakePrimaryLink',
        value: function onClickMakePrimaryLink(entityLink, type) {
            var _this2 = this;

            (0, _EntitylinksRest.makeEntityLinkPrimary)(entityLink, type, this.props.projectKey).then(function (response) {
                if (response.status === 200) {
                    _this2.props.onMakePrimary(entityLink);
                }
            });
        }
    }, {
        key: 'onClickToggleDropList',
        value: function onClickToggleDropList() {
            this.setState({
                isMoreActionsOpen: !this.state.isMoreActionsOpen
            });
        }
    }, {
        key: 'openDeleteDialog',
        value: function openDeleteDialog() {
            this.setState({
                isDeleteLinkModalOpen: true
            });
        }
    }, {
        key: 'closeDeleteDialog',
        value: function closeDeleteDialog() {
            this.setState({
                isDeleteLinkModalOpen: false
            });
        }
    }, {
        key: 'onOpenChange',
        value: function onOpenChange() {
            this.setState({
                isMoreActionsOpen: false
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            var _state = this.state,
                isMoreActionsOpen = _state.isMoreActionsOpen,
                isDeleteLinkModalOpen = _state.isDeleteLinkModalOpen;
            var _props = this.props,
                type = _props.type,
                entityLink = _props.entityLink,
                outgoingApplicationName = _props.outgoingApplicationName;

            return _react2.default.createElement(
                _react2.default.Fragment,
                null,
                _react2.default.createElement(
                    _Droplist2.default,
                    {
                        position: 'bottom right',
                        onClick: function onClick() {
                            return _this3.onClickToggleDropList();
                        },
                        onOpenChange: function onOpenChange() {
                            return _this3.onOpenChange();
                        },
                        isOpen: isMoreActionsOpen,
                        trigger: _react2.default.createElement(
                            _Button2.default,
                            { className: 'droplist' },
                            _react2.default.createElement(_more2.default, { size: 'small' })
                        )
                    },
                    _react2.default.createElement(
                        _item.ItemGroup,
                        null,
                        _react2.default.createElement(
                            _item2.default,
                            { onClick: function onClick() {
                                    return _this3.openDeleteDialog();
                                } },
                            _react2.default.createElement(
                                'span',
                                { className: 'delete-link-action' },
                                "Delete"
                            )
                        ),
                        !entityLink.isPrimary && _react2.default.createElement(
                            _item2.default,
                            { onClick: function onClick() {
                                    return _this3.onClickMakePrimaryLink(entityLink, type);
                                } },
                            "Make primary link"
                        )
                    )
                ),
                _react2.default.createElement(
                    _modalDialog.ModalTransition,
                    null,
                    isDeleteLinkModalOpen && _react2.default.createElement(_deleteEntityLinkDialog2.default, {
                        currentApp: this.props.currentApp,
                        outgoingApplicationName: outgoingApplicationName,
                        type: type,
                        projectKey: this.props.projectKey,
                        entityLink: entityLink,
                        onClose: function onClose() {
                            return _this3.closeDeleteDialog();
                        },
                        onDelete: this.props.onDelete
                    })
                )
            );
        }
    }]);

    return EntityLinksMoreActions;
}(_react.Component);

exports.default = EntityLinksMoreActions;

/***/ }),

/***/ 304:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _wrmReactI18n = __webpack_require__(74);

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _sectionMessage = __webpack_require__(187);

var _sectionMessage2 = _interopRequireDefault(_sectionMessage);

var _modalDialog = __webpack_require__(123);

var _modalDialog2 = _interopRequireDefault(_modalDialog);

var _button = __webpack_require__(66);

var _button2 = _interopRequireDefault(_button);

var _EntitylinksRest = __webpack_require__(122);

var _form = __webpack_require__(188);

var _form2 = _interopRequireDefault(_form);

var _checkbox = __webpack_require__(191);

var _authButton = __webpack_require__(181);

var _spinner = __webpack_require__(55);

var _spinner2 = _interopRequireDefault(_spinner);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var AuthStatus = {
    UNKNOWN: 'unknown',
    SUCCESSFULL: 'successfull',
    REQUIRED: 'required'
};

var DeleteEntityLinkDialogForm = function (_Component) {
    _inherits(DeleteEntityLinkDialogForm, _Component);

    function DeleteEntityLinkDialogForm(props) {
        _classCallCheck(this, DeleteEntityLinkDialogForm);

        var _this = _possibleConstructorReturn(this, (DeleteEntityLinkDialogForm.__proto__ || Object.getPrototypeOf(DeleteEntityLinkDialogForm)).call(this, props));

        _this.state = { authStatus: AuthStatus.UNKNOWN };
        return _this;
    }

    _createClass(DeleteEntityLinkDialogForm, [{
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.checkTwoWayDelete();
        }
    }, {
        key: 'checkTwoWayDelete',
        value: function checkTwoWayDelete() {
            var _this2 = this;

            (0, _EntitylinksRest.canDeleteEntityLinkResponse)(this.props.entityLink, this.props.type, this.props.projectKey).then(function (response) {
                return response.json();
            }).then(function (data) {
                var permissionCode = data.code;
                if (_EntitylinksRest.PermissionCode.CREDENTIALS_REQUIRED === permissionCode || _EntitylinksRest.PermissionCode.AUTHENTICATION_FAILED === permissionCode) {
                    _this2.setState({
                        authUrl: data.url,
                        authStatus: AuthStatus.REQUIRED
                    });
                } else {
                    _this2.setState({
                        twoWayAllowed: permissionCode === 'ALLOWED',
                        authStatus: AuthStatus.SUCCESSFULL
                    });
                }
            });
        }
    }, {
        key: 'getFooterButtons',
        value: function getFooterButtons() {
            var _this3 = this;

            return function () {
                return _react2.default.createElement(
                    _modalDialog.ModalFooter,
                    null,
                    _react2.default.createElement('span', null),
                    _react2.default.createElement(
                        _button.ButtonGroup,
                        null,
                        _react2.default.createElement(
                            _button2.default,
                            { appearance: 'danger', type: 'submit', className: 'delete-entitylink' },
                            "Delete"
                        ),
                        _react2.default.createElement(
                            _button2.default,
                            { appearance: 'subtle-link', onClick: _this3.props.onClose },
                            "Cancel"
                        )
                    )
                );
            };
        }
    }, {
        key: 'onDeleteSubmit',
        value: function onDeleteSubmit(data) {
            var deleteReciprocal = data.twowayselect || false;
            this.deleteLink(deleteReciprocal);
        }
    }, {
        key: 'deleteLink',
        value: function deleteLink(twoWay) {
            var _this4 = this;

            var _props = this.props,
                entityLink = _props.entityLink,
                type = _props.type,
                projectKey = _props.projectKey;

            (0, _EntitylinksRest.deleteEntityLink)(entityLink, type, projectKey, twoWay).then(function (response) {
                if (response.status === 200) {
                    _this4.props.onDelete(entityLink);
                }
            });
        }
    }, {
        key: 'getBody',
        value: function getBody() {
            var _this5 = this;

            var _state = this.state,
                twoWayAllowed = _state.twoWayAllowed,
                authStatus = _state.authStatus;

            switch (authStatus) {
                case AuthStatus.SUCCESSFULL:
                    return _react2.default.createElement(
                        _form.CheckboxField,
                        { name: 'twowayselect', defaultIsChecked: twoWayAllowed },
                        function (_ref) {
                            var fieldProps = _ref.fieldProps;
                            return _react2.default.createElement(_checkbox.Checkbox, _extends({}, fieldProps, {
                                isDisabled: !twoWayAllowed,
                                label: _wrmReactI18n.format("Delete reciprocal link from {1} to {0}.", _this5.props.currentApp, _this5.props.outgoingApplicationName)
                            }));
                        }
                    );
                case AuthStatus.REQUIRED:
                    debugger;
                    return _react2.default.createElement(
                        'div',
                        { className: 'info-auth-container' },
                        _react2.default.createElement(
                            _sectionMessage2.default,
                            {
                                appearance: 'info',
                                actions: [{
                                    text: _wrmReactI18n.format("Authorize", this.props.currentApp),
                                    onClick: function onClick() {
                                        return (0, _authButton.authorize)(_this5.state.authUrl, function () {
                                            return _this5.checkTwoWayDelete();
                                        });
                                    },
                                    key: 'authorize-link'
                                }]
                            },
                            _react2.default.createElement(
                                'p',
                                null,
                                _wrmReactI18n.format("Granting {0} authorized access to {1} allows you to delete 2-way project links between these applications", this.props.currentApp, this.props.outgoingApplicationName)
                            ),
                            _react2.default.createElement(
                                'p',
                                null,
                                _wrmReactI18n.format("If you don''t authorize {0}, you''ll only be able to delete 1-way links from {0} to {1}. Links back to {0} needs to be deleted in the {1} project administration settings.", this.props.currentApp, this.props.outgoingApplicationName)
                            )
                        )
                    );
                default:
                    return _react2.default.createElement(
                        'div',
                        { className: 'info-auth-container' },
                        _react2.default.createElement(
                            _sectionMessage2.default,
                            { appearance: 'info' },
                            _react2.default.createElement(
                                'p',
                                null,
                                "Checking two way linking permissions",
                                ' ',
                                _react2.default.createElement(_spinner2.default, { size: 'small' })
                            )
                        )
                    );
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this6 = this;

            var _props2 = this.props,
                entityLink = _props2.entityLink,
                projectKey = _props2.projectKey;

            return _react2.default.createElement(
                _modalDialog2.default,
                {
                    heading: "Delete project link",
                    autoFocus: true,
                    onClose: this.props.onClose,
                    components: {
                        Container: function Container(_ref2) {
                            var children = _ref2.children,
                                className = _ref2.className;
                            return _react2.default.createElement(
                                _form2.default,
                                { onSubmit: function onSubmit(data) {
                                        return _this6.onDeleteSubmit(data);
                                    } },
                                function (_ref3) {
                                    var formProps = _ref3.formProps;
                                    return _react2.default.createElement(
                                        'form',
                                        _extends({}, formProps, { className: className }),
                                        children
                                    );
                                }
                            );
                        },
                        Footer: this.getFooterButtons()
                    }
                },
                _react2.default.createElement(
                    'p',
                    null,
                    _wrmReactI18n.format("Delete the link to the project {0} on {1}", entityLink.name, this.props.outgoingApplicationName)
                ),
                this.getBody()
            );
        }
    }]);

    return DeleteEntityLinkDialogForm;
}(_react.Component);

exports.default = DeleteEntityLinkDialogForm;

/***/ }),

/***/ 342:
/***/ (function(module, exports, __webpack_require__) {

// extracted by mini-css-extract-plugin

/***/ }),

/***/ 344:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = __webpack_require__(0);

var _react2 = _interopRequireDefault(_react);

var _select = __webpack_require__(353);

var _select2 = _interopRequireDefault(_select);

var _checkbox = __webpack_require__(191);

var _form = __webpack_require__(188);

var _form2 = _interopRequireDefault(_form);

var _modalDialog = __webpack_require__(123);

var _modalDialog2 = _interopRequireDefault(_modalDialog);

var _wrmReactI18n = __webpack_require__(74);

var _button = __webpack_require__(66);

var _button2 = _interopRequireDefault(_button);

var _sectionMessage = __webpack_require__(187);

var _sectionMessage2 = _interopRequireDefault(_sectionMessage);

var _EntitylinksRest = __webpack_require__(122);

var _authButton = __webpack_require__(181);

var _authButton2 = _interopRequireDefault(_authButton);

var _spinner = __webpack_require__(55);

var _spinner2 = _interopRequireDefault(_spinner);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ValidationState = {
    ERROR: 'error',
    DEFAULT: 'default'
};

var ApplinkStatus = {
    NO_MORE_PROJECTS: 'no_more_projects',
    REQUEST_FAILED: 'request_failed',
    AUTHENTICATION_REQUIRED: 'authentication_required'
};

var Option = function Option(_ref) {
    var iconUri = _ref.iconUri,
        primary = _ref.primary,
        secondary = _ref.secondary;
    return _react2.default.createElement(
        'div',
        { className: 'option' },
        _react2.default.createElement('img', { src: iconUri, width: 20, height: 20 }),
        primary,
        _react2.default.createElement(
            'span',
            { className: 'secondary-container' },
            secondary
        )
    );
};

var getApplicationOption = function getApplicationOption(option) {
    return _react2.default.createElement(Option, { iconUri: option.data.iconUri, primary: option.name, secondary: option.displayUrl });
};

var getProjectOption = function getProjectOption(option) {
    return _react2.default.createElement(Option, { iconUri: option.iconUri, primary: option.name, secondary: option.key });
};

var CreateEntityLinkDialogForm = function (_Component) {
    _inherits(CreateEntityLinkDialogForm, _Component);

    function CreateEntityLinkDialogForm(props) {
        _classCallCheck(this, CreateEntityLinkDialogForm);

        var _this = _possibleConstructorReturn(this, (CreateEntityLinkDialogForm.__proto__ || Object.getPrototypeOf(CreateEntityLinkDialogForm)).call(this, props));

        _this.state = {
            projects: [],
            selectedProject: null,
            appFieldValue: '',
            projectFieldValue: '',
            twoWayAllowed: false,
            appLinkHealth: null,
            authUrl: null
        };
        return _this;
    }

    _createClass(CreateEntityLinkDialogForm, [{
        key: 'checkTwoWayAllowed',
        value: function checkTwoWayAllowed(selectedApplink) {
            var _this2 = this;

            (0, _EntitylinksRest.getPermissionsResponse)(selectedApplink).then(function (response) {
                return response.json();
            }).then(function (data) {
                var permissionCode = data.code;
                switch (permissionCode) {
                    case _EntitylinksRest.PermissionCode.NO_PERMISSION:
                    case _EntitylinksRest.PermissionCode.ALLOWED:
                        _this2.setState({ twoWayAllowed: permissionCode === 'ALLOWED' });
                        _this2.loadProjectsForSelect(selectedApplink, (0, _EntitylinksRest.getProjectsResponse)(selectedApplink));
                        break;
                    case _EntitylinksRest.PermissionCode.CREDENTIALS_REQUIRED:
                    case _EntitylinksRest.PermissionCode.AUTHENTICATION_FAILED:
                        _this2.setState({
                            applinkHealth: ApplinkStatus.AUTHENTICATION_REQUIRED,
                            authUrl: data.url
                        });
                        break;
                    default:
                        console.error('Something is wrong with the applink the status was: ' + permissionCode);
                        _this2.setState({ applinkHealth: ApplinkStatus.REQUEST_FAILED });
                }
            }).catch(function (e) {
                console.error('Something went wrong ' + e);
                _this2.setState({ applinkHealth: ApplinkStatus.REQUEST_FAILED });
            });
        }
    }, {
        key: 'onProjectSelected',
        value: function onProjectSelected(selectedOption) {
            var selectedApplink = selectedOption.value;
            this.setState({
                appFieldValue: selectedOption,
                projects: [],
                applinkHealth: null
            });
            this.checkTwoWayAllowed(selectedApplink);
        }
    }, {
        key: 'skipAuthentication',
        value: function skipAuthentication() {
            var selectedApplink = this.state.appFieldValue.value;
            this.loadProjectsForSelect(selectedApplink, (0, _EntitylinksRest.getAnonymousProjectsResponse)(selectedApplink));
        }
    }, {
        key: 'loadProjectsForSelect',
        value: function loadProjectsForSelect(selectedApplink, fetchResponse) {
            var _this3 = this;

            fetchResponse.then(function (response) {
                return response.json();
            }).then(function (data) {
                var projects = data.entity.map(function (entity) {
                    return _extends({}, entity, {
                        label: entity.name,
                        value: entity.key
                    });
                }).filter(function (link) {
                    //filter out existing links
                    return !_this3.doesLinkExists(link, selectedApplink);
                });
                _this3.setState({
                    projects: projects,
                    applinkHealth: projects.length === 0 ? ApplinkStatus.NO_MORE_PROJECTS : null
                });
            });
        }
    }, {
        key: 'doesLinkExists',
        value: function doesLinkExists(link, selectedApplink) {
            return this.props.entityLinks.some(function (other) {
                return link.key === other.key && selectedApplink === other.applicationId;
            });
        }
    }, {
        key: 'createEntityLink',
        value: function createEntityLink(data) {
            var _this4 = this;

            if (this.state.applinkHealth === ApplinkStatus.NO_MORE_PROJECTS) {
                //not really being able to validate this in the AK form because, well AK so we need to check it manually.
                return;
            }
            var _props = this.props,
                projectKey = _props.projectKey,
                type = _props.type;

            var entityLink = {
                applicationId: this.state.appFieldValue.value,
                typeId: data['project-select'].typeId,
                key: data['project-select'].value,
                name: data['project-select'].name
            };
            (0, _EntitylinksRest.createReciproticalLink)(entityLink, projectKey, type, data.twowayselect).then(function (response) {
                return response.json();
            }).then(function (data) {
                _this4.props.onEntityAdded(data);
                _this4.props.onClose();
            });
        }
    }, {
        key: 'validateEmpty',
        value: function validateEmpty(value) {
            if (!value) {
                return 'EMPTY';
            }

            return;
        }
    }, {
        key: 'getButtons',
        value: function getButtons() {
            var _this5 = this;

            if (this.state.applinkHealth === ApplinkStatus.AUTHENTICATION_REQUIRED) {
                return function () {
                    return _react2.default.createElement(
                        _modalDialog.ModalFooter,
                        null,
                        _react2.default.createElement(
                            _button2.default,
                            { appearance: 'link', onClick: function onClick(e) {
                                    return _this5.skipAuthentication();
                                } },
                            _wrmReactI18n.format("Don''t authorize {0}", _this5.props.currentApp)
                        ),
                        _react2.default.createElement(
                            _button.ButtonGroup,
                            null,
                            _react2.default.createElement(_authButton2.default, {
                                successCallback: function successCallback() {
                                    return _this5.onProjectSelected(_this5.state.appFieldValue);
                                },
                                url: _this5.state.authUrl,
                                currentApp: _this5.props.currentApp
                            }),
                            _react2.default.createElement(
                                _button2.default,
                                { appearance: 'subtle-link', onClick: _this5.props.onClose },
                                "Cancel"
                            )
                        )
                    );
                };
            } else {
                return function () {
                    return _react2.default.createElement(
                        _modalDialog.ModalFooter,
                        null,
                        _react2.default.createElement('span', null),
                        _react2.default.createElement(
                            _button.ButtonGroup,
                            null,
                            _react2.default.createElement(
                                _button2.default,
                                { appearance: 'primary', type: 'submit', className: 'create-link' },
                                "Create link"
                            ),
                            _react2.default.createElement(
                                _button2.default,
                                { appearance: 'subtle-link', onClick: _this5.props.onClose },
                                "Cancel"
                            )
                        )
                    );
                };
            }
        }
    }, {
        key: 'render',
        value: function render() {
            var _this6 = this;

            var applinks = this.props.applicationLinks.map(function (link) {
                return _extends({}, link, {
                    label: link.name,
                    value: link.id
                });
            });

            var applicationSelected = this.state.projects.length > 0;
            var isLoadingProjects = this.state.projects.length === 0 && this.state.applinkHealth === null && this.state.appFieldValue;
            var authenticationRequired = this.state.applinkHealth === ApplinkStatus.AUTHENTICATION_REQUIRED;

            var getValidationState = function getValidationState(error, valid) {
                if (_this6.state.applinkHealth === ApplinkStatus.NO_MORE_PROJECTS || error) {
                    return ValidationState.ERROR;
                }

                return ValidationState.DEFAULT;
            };

            return _react2.default.createElement(
                _modalDialog2.default,
                {
                    heading: "Create project link",
                    onClose: this.props.onClose,
                    autoFocus: true,
                    components: {
                        Container: function Container(_ref2) {
                            var children = _ref2.children,
                                className = _ref2.className;
                            return _react2.default.createElement(
                                _form2.default,
                                { onSubmit: function onSubmit(data) {
                                        return _this6.createEntityLink(data);
                                    } },
                                function (_ref3) {
                                    var formProps = _ref3.formProps;
                                    return _react2.default.createElement(
                                        'form',
                                        _extends({}, formProps, { className: className }),
                                        children
                                    );
                                }
                            );
                        },
                        Footer: this.getButtons()
                    }
                },
                _react2.default.createElement(
                    'div',
                    null,
                    _react2.default.createElement(
                        'p',
                        null,
                        "Choose a linked Atlassian application, then choose a project in it to link to."
                    ),
                    _react2.default.createElement(
                        _form.Field,
                        {
                            label: "Select application",
                            helperText: "Select an application",
                            id: 'applselect',
                            name: 'application-select',
                            validate: this.validateEmpty,
                            defaultValue: this.state.appFieldValue
                        },
                        function (_ref4) {
                            var fieldProps = _ref4.fieldProps,
                                error = _ref4.error;
                            return _react2.default.createElement(
                                _react.Fragment,
                                null,
                                _react2.default.createElement(_select2.default, _extends({}, fieldProps, {
                                    menuPortalTarget: document.body,
                                    styles: { menuPortal: function menuPortal(base) {
                                            return _extends({}, base, { zIndex: 9999 });
                                        } },
                                    formatOptionLabel: getApplicationOption,
                                    className: 'single-select',
                                    classNamePrefix: 'react-select',
                                    options: applinks,
                                    placeholder: "Choose an application",
                                    onChange: function onChange(value) {
                                        fieldProps.onChange(value);
                                        _this6.onProjectSelected(value);
                                    },
                                    validationState: getValidationState(error)
                                })),
                                error === 'EMPTY' && _react2.default.createElement(
                                    _form.ErrorMessage,
                                    null,
                                    "You must choose an application"
                                ),
                                _this6.state.applinkHealth === ApplinkStatus.NO_MORE_PROJECTS && _react2.default.createElement(
                                    _form.ErrorMessage,
                                    null,
                                    "There are no projects to link to."
                                ),
                                _this6.state.applinkHealth === ApplinkStatus.REQUEST_FAILED && _react2.default.createElement(
                                    _form.ErrorMessage,
                                    null,
                                    "You’ll not be able to create this project link until the issue with the Application Link is resolved."
                                )
                            );
                        }
                    ),
                    isLoadingProjects && _react2.default.createElement(
                        'div',
                        { className: 'spinner-container' },
                        _react2.default.createElement(_spinner2.default, { size: 'large' })
                    ),
                    applicationSelected && _react2.default.createElement(
                        'div',
                        null,
                        _react2.default.createElement(
                            _form.Field,
                            {
                                label: "Select project",
                                helperText: "Please select a project",
                                id: 'projectselect',
                                validate: this.validateEmpty,
                                name: 'project-select'
                            },
                            function (_ref5) {
                                var fieldProps = _ref5.fieldProps,
                                    error = _ref5.error;
                                return _react2.default.createElement(
                                    _react.Fragment,
                                    null,
                                    _react2.default.createElement(_select2.default, _extends({
                                        autoFocus: true
                                    }, fieldProps, {
                                        formatOptionLabel: getProjectOption,
                                        menuPortalTarget: document.body,
                                        styles: {
                                            menuPortal: function menuPortal(base) {
                                                return _extends({}, base, { zIndex: 9998 });
                                            }
                                        },
                                        className: 'single-select',
                                        classNamePrefix: 'react-select',
                                        options: _this6.state.projects,
                                        placeholder: "Choose a project",
                                        validationState: getValidationState(error)
                                    })),
                                    error === 'EMPTY' && _react2.default.createElement(
                                        _form.ErrorMessage,
                                        null,
                                        "Select a project"
                                    )
                                );
                            }
                        ),
                        _react2.default.createElement(
                            _form.CheckboxField,
                            {
                                name: 'twowayselect',
                                defaultIsChecked: this.state.twoWayAllowed
                            },
                            function (_ref6) {
                                var fieldProps = _ref6.fieldProps;
                                return _react2.default.createElement(_checkbox.Checkbox, _extends({}, fieldProps, {
                                    isDisabled: !_this6.state.twoWayAllowed,
                                    label: "Make this a 2-way link"
                                }));
                            }
                        )
                    ),
                    authenticationRequired && _react2.default.createElement(
                        'div',
                        { className: 'info-auth-container' },
                        _react2.default.createElement(
                            _sectionMessage2.default,
                            {
                                appearance: 'info',
                                title: _wrmReactI18n.format("Authorize {0} to access {1}", this.props.currentApp, this.state.appFieldValue.type)
                            },
                            _react2.default.createElement(
                                'p',
                                null,
                                "Most links require certain access rights to create a link. You can link without authorizing now, but that could limit the amount of projects you can link to."
                            )
                        )
                    )
                )
            );
        }
    }]);

    return CreateEntityLinkDialogForm;
}(_react.Component);

exports.default = CreateEntityLinkDialogForm;

/***/ }),

/***/ 349:
/***/ (function(module, exports) {

module.exports = require("applinks/common/help-paths");

/***/ })

},[[243,1,2]]]);
//# sourceMappingURL=entitylink-page-init.bundle.js.map