define('applinks/lib/aui-version-details', [
    'applinks/lib/version'
], function(
    Version
) {
    // minimum 5.8.x and 5.9.x AUI versions - lower versions ship with bugs that break some of the Applinks functionality
    var MINIMUM_58_VERSION = new Version(5, 8, 15);
    var MINIMUM_59_VERSION = new Version(5, 9, 13);
    var VERSION_58 = new Version(5, 8);
    var VERSION_59 = new Version(5, 9);

    function checkVersion(version) {
        // must be >= the minimum required 5.8.x version
        if (version.lessThan(MINIMUM_58_VERSION)) {
            throw new Error('AUI version ' + version + ' is too low, you need to upgrade AUI to ' + MINIMUM_58_VERSION +
                ' or ' + MINIMUM_59_VERSION + ' for Applinks to work');
        }
        // if 5.9, must be >= the minimum required 5.9.x version
        if (version.greaterThanOrEqual(VERSION_59) && version.lessThan(MINIMUM_59_VERSION)) {
            throw new Error('AUI version ' + version + ' is too low, you need to upgrade AUI to ' + MINIMUM_59_VERSION +
                ' for Applinks to work');
        }
    }

    function addVersionDetails(AJS) {
        var ajsVersion = Version.parse(AJS.version, 'AUI version');
        checkVersion(ajsVersion);

        AJS.versionDetails = ajsVersion;
        AJS.versionDetails.is58 = ajsVersion.toMinor().equals(VERSION_58);
        AJS.versionDetails.is59 = ajsVersion.toMinor().equals(VERSION_59);

        return AJS;
    }

    return  {
        /**
         * Check AUI version for compatibility with Applinks and add `versionDetails` field.
         */
        addVersionDetails: addVersionDetails
    };
});