/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import io.swagger.models.properties.PropertyBuilder;
import io.swagger.util.AllowableValues;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AllowableRangeValues
implements AllowableValues {
    private static final Pattern RANGE_PATTERN = Pattern.compile("range(\\[|\\()([^,\\s]+)\\s*,\\s*([^\\]\\s]+)\\s*(\\]|\\))");
    private static final String POSITIVE_INFINITY_KEY = "infinity";
    private static final String NEGATIVE_INFINITY_KEY = "-infinity";
    private static final String OPEN_EXCLUSIVE_RANGE_KEY = "(";
    private static final String CLOSE_EXCLUSIVE_RANGE_KEY = ")";
    private final Double minimum;
    private final Double maximum;
    private final boolean exclusiveMinimum;
    private final boolean exclusiveMaximum;

    private AllowableRangeValues(Double minimum, boolean exclusiveMinimum, Double maximum, boolean exclusiveMaximum) {
        this.minimum = minimum;
        this.exclusiveMinimum = exclusiveMinimum;
        this.maximum = maximum;
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public static AllowableRangeValues create(String allowableValues) {
        Matcher matcher = RANGE_PATTERN.matcher(allowableValues);
        return matcher.find() ? new AllowableRangeValues(AllowableRangeValues.findRangeValue(matcher.group(2)), AllowableRangeValues.isExclusiveRange(matcher.group(1)), AllowableRangeValues.findRangeValue(matcher.group(3)), AllowableRangeValues.isExclusiveRange(matcher.group(4))) : null;
    }

    private static Double findRangeValue(String value) {
        if (POSITIVE_INFINITY_KEY.equalsIgnoreCase(value) || NEGATIVE_INFINITY_KEY.equalsIgnoreCase(value)) {
            return null;
        }
        return Double.parseDouble(value);
    }

    private static boolean isExclusiveRange(String value) {
        return OPEN_EXCLUSIVE_RANGE_KEY.equals(value) || CLOSE_EXCLUSIVE_RANGE_KEY.equals(value);
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    @Override
    public Map<PropertyBuilder.PropertyId, Object> asPropertyArguments() {
        EnumMap<PropertyBuilder.PropertyId, Object> map = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        map.put(PropertyBuilder.PropertyId.MINIMUM, this.minimum);
        map.put(PropertyBuilder.PropertyId.MAXIMUM, this.maximum);
        if (this.exclusiveMinimum) {
            map.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)this.exclusiveMinimum);
        }
        if (this.exclusiveMaximum) {
            map.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)this.exclusiveMaximum);
        }
        return map;
    }
}

