/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.status.oauth;

import com.atlassian.applinks.internal.common.status.oauth.OAuthConfig;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class ApplinkOAuthStatus {
    public static final ApplinkOAuthStatus DEFAULT = new ApplinkOAuthStatus(OAuthConfig.createDefaultOAuthConfig(), OAuthConfig.createDefaultOAuthConfig());
    public static final ApplinkOAuthStatus IMPERSONATION = new ApplinkOAuthStatus(OAuthConfig.createOAuthWithImpersonationConfig(), OAuthConfig.createOAuthWithImpersonationConfig());
    public static final ApplinkOAuthStatus OFF = new ApplinkOAuthStatus(OAuthConfig.createDisabledConfig(), OAuthConfig.createDisabledConfig());
    private final OAuthConfig incoming;
    private final OAuthConfig outgoing;

    public ApplinkOAuthStatus(@Nonnull OAuthConfig incoming, @Nonnull OAuthConfig outgoing) {
        this.incoming = (OAuthConfig)Preconditions.checkNotNull((Object)incoming, (Object)"incoming");
        this.outgoing = (OAuthConfig)Preconditions.checkNotNull((Object)outgoing, (Object)"outgoing");
    }

    @Nonnull
    public OAuthConfig getIncoming() {
        return this.incoming;
    }

    @Nonnull
    public OAuthConfig getOutgoing() {
        return this.outgoing;
    }

    public boolean matches(@Nonnull ApplinkOAuthStatus other) {
        Preconditions.checkNotNull((Object)other, (Object)"other");
        return this.incoming.equals(other.getOutgoing()) && this.outgoing.equals(other.getIncoming());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplinkOAuthStatus status = (ApplinkOAuthStatus)o;
        return Objects.equal((Object)this.incoming, (Object)status.incoming) && Objects.equal((Object)this.outgoing, (Object)status.outgoing);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.incoming, this.outgoing});
    }
}

