/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model.status;

import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.applinks.internal.rest.model.status.RestAuthorisationUriAwareApplinkError;
import com.atlassian.applinks.internal.status.error.ApplinkError;
import com.atlassian.applinks.internal.status.error.ApplinkErrorVisitor;
import com.atlassian.applinks.internal.status.error.AuthorisationUriAwareApplinkError;
import com.atlassian.applinks.internal.status.error.ResponseApplinkError;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestApplinkError
extends BaseRestEntity {
    public static final String CATEGORY = "category";
    public static final String DETAILS = "details";
    public static final String TYPE = "type";

    public RestApplinkError(@Nonnull ApplinkError errorDetails) {
        Preconditions.checkNotNull((Object)errorDetails, (Object)"errorDetails");
        this.put(CATEGORY, (Object)errorDetails.getType().getCategory().name());
        this.put(TYPE, (Object)errorDetails.getType().name());
        this.putIfNotNull(DETAILS, errorDetails.getDetails());
    }

    public static final class Visitor
    implements ApplinkErrorVisitor<RestApplinkError> {
        private final URI authorisationCallback;

        public Visitor() {
            this(null);
        }

        public Visitor(@Nullable URI authorisationCallback) {
            this.authorisationCallback = authorisationCallback;
        }

        @Override
        @Nullable
        public RestApplinkError visit(@Nonnull ApplinkError error) {
            return new RestApplinkError(error);
        }

        @Override
        @Nullable
        public RestApplinkError visit(@Nonnull AuthorisationUriAwareApplinkError error) {
            return new RestAuthorisationUriAwareApplinkError(error, this.authorisationCallback);
        }

        @Override
        @Nullable
        public RestApplinkError visit(@Nonnull ResponseApplinkError responseError) {
            return new RestApplinkError(responseError);
        }
    }
}

