/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.rest.util;

import com.atlassian.applinks.internal.common.rest.util.RestResponses;
import com.atlassian.applinks.internal.rest.model.RestError;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class RestEnumParser<E extends Enum<E>> {
    public static final String DEFAULT_MESSAGE_KEY = "applinks.rest.enum.notfound";
    private final I18nResolver i18nResolver;
    private final Response.Status errorStatus;
    private final String errorMessageKey;
    private final Class<E> enumType;

    public RestEnumParser(@Nonnull Class<E> enumType, @Nonnull I18nResolver i18nResolver, @Nonnull String errorMessageKey, @Nullable Response.Status errorStatus) {
        this.enumType = (Class)Preconditions.checkNotNull(enumType, (Object)"enumType");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.errorStatus = errorStatus != null ? errorStatus : Response.Status.BAD_REQUEST;
        this.errorMessageKey = (String)Preconditions.checkNotNull((Object)errorMessageKey, (Object)"errorMessageKey");
    }

    public RestEnumParser(@Nonnull Class<E> enumType, @Nonnull I18nResolver i18nResolver, @Nonnull String errorMessageKey) {
        this(enumType, i18nResolver, errorMessageKey, null);
    }

    public RestEnumParser(@Nonnull Class<E> enumType, @Nonnull I18nResolver i18nResolver) {
        this(enumType, i18nResolver, DEFAULT_MESSAGE_KEY);
    }

    @Nonnull
    public E parseEnumParameter(@Nonnull String name, @Nonnull String context) {
        Preconditions.checkNotNull((Object)name, (Object)"value");
        try {
            return Enum.valueOf(this.enumType, name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(this.badEnumParam(name, context));
        }
    }

    @Nonnull
    public E parseEnumParameter(@Nullable String name, @Nonnull E defaultValue, @Nonnull String context) {
        return StringUtils.isNotEmpty(name) ? this.parseEnumParameter(name, context) : defaultValue;
    }

    private Response badEnumParam(String name, String context) {
        return RestResponses.error(this.errorStatus, new RestError(context, this.i18nResolver.getText(this.errorMessageKey, new Serializable[]{name, context}), null));
    }
}

