/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.rest.model.status;

import com.atlassian.applinks.internal.common.status.oauth.OAuthConfig;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.applinks.internal.rest.model.RestRepresentation;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestOAuthConfig
extends BaseRestEntity
implements RestRepresentation<OAuthConfig> {
    public static final String ENABLED = "enabled";
    public static final String TWO_LO_ENABLED = "twoLoEnabled";
    public static final String TWO_LO_IMPERSONATION_ENABLED = "twoLoImpersonationEnabled";

    public RestOAuthConfig() {
    }

    public RestOAuthConfig(@Nonnull Map<String, Object> original) {
        super(original);
    }

    public RestOAuthConfig(@Nonnull OAuthConfig oAuthConfig) {
        Preconditions.checkNotNull((Object)oAuthConfig, (Object)"oAuthConfig");
        this.put(ENABLED, (Object)oAuthConfig.isEnabled());
        this.put(TWO_LO_ENABLED, (Object)oAuthConfig.isTwoLoEnabled());
        this.put(TWO_LO_IMPERSONATION_ENABLED, (Object)oAuthConfig.isTwoLoImpersonationEnabled());
    }

    @Override
    @Nonnull
    public OAuthConfig asDomain() {
        if (!this.getBooleanValue(ENABLED)) {
            return OAuthConfig.createDisabledConfig();
        }
        if (this.getBooleanValue(TWO_LO_IMPERSONATION_ENABLED)) {
            return OAuthConfig.createOAuthWithImpersonationConfig();
        }
        if (this.getBooleanValue(TWO_LO_ENABLED)) {
            return OAuthConfig.createDefaultOAuthConfig();
        }
        return OAuthConfig.createThreeLoOnlyConfig();
    }
}

