/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.rest.model.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.internal.common.application.ApplicationTypes;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.applinks.internal.rest.model.ReadOnlyRestRepresentation;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;

public class RestMinimalApplicationLink
extends BaseRestEntity
implements ReadOnlyRestRepresentation<ApplicationLink> {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DISPLAY_URL = "displayUrl";
    public static final String RPC_URL = "rpcUrl";
    public static final String TYPE = "type";

    public RestMinimalApplicationLink() {
    }

    public RestMinimalApplicationLink(@Nonnull Map<String, Object> source) {
        super(source);
    }

    public RestMinimalApplicationLink(@Nonnull ApplicationLink link) {
        Preconditions.checkNotNull((Object)link, (Object)"link");
        this.put(ID, (Object)link.getId().get());
        this.put(NAME, (Object)link.getName());
        this.put(DISPLAY_URL, (Object)link.getDisplayUrl());
        this.put(RPC_URL, (Object)link.getRpcUrl());
        this.put(TYPE, (Object)ApplicationTypes.resolveApplicationTypeId(link.getType()));
    }

    @Nonnull
    public final String getName() {
        return this.getRequiredString(NAME);
    }

    @Nonnull
    public final String getRpcUrl() {
        return this.getRequiredString(RPC_URL);
    }

    @Nonnull
    public final String getDisplayUrl() {
        return this.getRequiredString(DISPLAY_URL);
    }
}

