/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.permission;

import com.atlassian.annotations.Internal;
import com.atlassian.applinks.internal.common.permission.PermissionLevel;
import com.atlassian.applinks.internal.common.permission.Unrestricted;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Unrestricted(value="The goal of this component is to allow anonymous code to execute with elevated permissions")
@Internal
public final class ElevatedPermissions {
    private static final ThreadLocal<PermissionLevel> PERMISSION_LEVEL_CONTEXT = new ThreadLocal();

    private ElevatedPermissions() {
    }

    @Nullable
    public static <T> T executeAs(@Nonnull PermissionLevel level, @Nonnull Callable<T> closure) throws Exception {
        Preconditions.checkNotNull((Object)((Object)level), (Object)"level");
        Preconditions.checkNotNull(closure, (Object)"closure");
        PERMISSION_LEVEL_CONTEXT.set(level);
        try {
            T t = closure.call();
            return t;
        }
        finally {
            PERMISSION_LEVEL_CONTEXT.remove();
        }
    }

    public static boolean isElevatedTo(@Nonnull PermissionLevel level) {
        Preconditions.checkNotNull((Object)((Object)level), (Object)"level");
        PermissionLevel current = PERMISSION_LEVEL_CONTEXT.get();
        return current != null && current.ordinal() >= level.ordinal();
    }
}

