/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.util;

import com.atlassian.applinks.internal.common.net.Uris;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class URIUtil {
    public static String concatenate(String base, String ... paths) {
        return StringUtils.stripEnd(base, "/") + URIUtil.removeRedundantSlashes("/" + StringUtils.join((Object[])paths, "/"));
    }

    public static URI concatenate(URI base, String ... paths) throws URISyntaxException {
        return new URI(URIUtil.concatenate(base.toASCIIString(), paths));
    }

    public static URI concatenate(URI base, URI ... paths) {
        try {
            String[] pathStrings = (String[])Iterables.toArray((Iterable)Lists.transform((List)Lists.newArrayList((Object[])paths), (Function)new Function<URI, String>(){

                public String apply(@Nullable URI from) {
                    return from.toASCIIString();
                }
            }), String.class);
            return URIUtil.concatenate(base, pathStrings);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to concatenate URIs", e);
        }
    }

    public static String utf8Encode(String string) {
        return Uris.utf8Encode(string);
    }

    public static String utf8Decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not installed!?", e);
        }
    }

    public static String utf8Encode(URI uri) {
        return Uris.utf8Encode(uri);
    }

    @Deprecated
    @Nonnull
    public static URI uncheckedToUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Failed to convert %s to URI (%s)", uri, e.getReason()), e);
        }
    }

    public static URI uncheckedConcatenateAndToUri(String base, String ... paths) {
        return URIUtil.uncheckedToUri(URIUtil.concatenate(base, paths));
    }

    public static URI uncheckedConcatenate(URI base, String ... paths) {
        try {
            return URIUtil.concatenate(base, paths);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Failed to concatenate %s to form URI (%s)", base, e.getReason()), e);
        }
    }

    public static URI uncheckedCreate(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("%s is not a valid URI (%s)", uri, e.getReason()), e);
        }
    }

    public static String removeRedundantSlashes(String path) {
        return Uris.removeRedundantSlashes(path);
    }

    public static URI copyOf(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri.toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to copy URI: " + uri.toASCIIString());
        }
    }
}

