package com.atlassian.applinks.internal.rest.applink.data;

import java.util.Set;
import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 5.0
 */
public abstract class AbstractRestApplinkDataProvider implements RestApplinkDataProvider {
    protected final Set<String> supportedKeys;

    protected AbstractRestApplinkDataProvider(@Nonnull Set<String> supportedKeys) {
        this.supportedKeys = checkNotNull(supportedKeys, "supportedKeys");
    }

    @Override
    @Nonnull
    public final Set<String> getSupportedKeys() {
        return supportedKeys;
    }

}
