package com.atlassian.applinks.internal.event;

import com.atlassian.applinks.internal.status.ApplinkStatus;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

@AsynchronousPreferred
public class StatusLoadedEvent {
    private final ApplinkStatus status;

    public StatusLoadedEvent(@Nonnull final ApplinkStatus status) {
        this.status = checkNotNull(status, "status");
    }

    public ApplinkStatus getStatus() {
        return status;
    }
}
