package com.atlassian.applinks.internal.rest.model.migration;

import com.atlassian.applinks.internal.common.capabilities.RemoteApplicationCapabilities;
import com.atlassian.applinks.internal.migration.AuthenticationStatus;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.google.common.annotations.VisibleForTesting;

import javax.annotation.Nonnull;

import java.util.Objects;

import static com.google.common.base.Preconditions.checkNotNull;

public class RestAuthenticationStatus extends BaseRestEntity {

    @VisibleForTesting
    public static final String OUTGOING = "outgoing";
    @VisibleForTesting
    public static final String INCOMING = "incoming";
    @VisibleForTesting
    public static final String CAPABILITIES = "capabilities";

    public RestAuthenticationStatus(@Nonnull final AuthenticationStatus authenticationStatus, @Nonnull final RemoteApplicationCapabilities remoteCapabilities) {
        Objects.requireNonNull(authenticationStatus, "authenticationConfigs");
        Objects.requireNonNull(remoteCapabilities, "remoteCapabilities");

        put(OUTGOING, new RestAuthenticationConfig(authenticationStatus.outgoing()));
        put(INCOMING, new RestAuthenticationConfig(authenticationStatus.incoming()));
        put(CAPABILITIES, remoteCapabilities.getCapabilities());
    }
}
