(function(){
    var typeIdMap = {
        "jira": "JIRA",
        "fecru": "Fisheye/Crucible",
        "fecru.project": "Fisheye/Crucible Project"
    };

    AppLinks.Util = {
        /**
         * In the (possible) absence of an AUI way to do this check if the browser is IE8
         * @returns {*|boolean}
         */
        isPreIE9: function() {
            return jQuery.browser.msie && jQuery.browser.version <= 8;
        },
        getApplicationType: function(typeId) {
            var applicationType = typeIdMap[typeId];
            return applicationType ? applicationType : (typeId.charAt(0).toUpperCase() + typeId.slice(1));
        },
        manifestToApplication: function(manifest) {
            return {
                url: manifest.url,
                rpcUrl: manifest.url,
                name: manifest.name,
                product: manifest.typeId ? AppLinks.Util.getApplicationType(manifest.typeId) : undefined,
                logoUrl: manifest.iconUri ? manifest.iconUri : manifest.iconUrl,
                typeId: manifest.typeId,
                id: manifest.id,
                applinksVersion: manifest.applinksVersion,
                publicSignUp: manifest.publicSignup
            }
        },
        waitUntilDone: function(callback){
            var callbacks = callback(),
                wait = callbacks.wait,
                done = callbacks.done;

            var deferred = new AJS.$.Deferred();
            wait();
            setTimeout(function(){
                deferred.resolve();
            }, 2000);

            return function(){
                deferred.done(done);
            };
        },
        getFieldValueFromQueryString: function (queryString, fieldName)
        {
            var fieldIndex = window.location.search.indexOf(fieldName);
            if (fieldIndex<0) {
                return null;
            }
            var fieldValueString;
            var nextParamIndex = queryString.slice(fieldIndex).indexOf("&");
            if (nextParamIndex > 0) {
                fieldValueString = queryString.slice(fieldIndex + fieldName.length + "=".length, fieldIndex + nextParamIndex);
            } else {
                fieldValueString = queryString.slice(fieldIndex + fieldName.length + "=".length);
            }

            var decodedFieldValue = decodeURIComponent(fieldValueString);
            try {
                return JSON.parse(decodedFieldValue);
            } catch(e) {
                console.log('Unable to JSON parse:' + decodedFieldValue + "] using as is");
                return decodedFieldValue;
            }
            return null;
        },
        /**
         * Find the value for the named parameter.
         * Checks first in sessionStorage and then in the queryString.
         * @param fieldName the name of the parameter.
         * @param clean flag indicating if the value should be read and then cleared for sessionStorage.
         */
        getParameterValue: function (fieldName, clean)
        {
            // check sessionstorage first
            if(typeof(Storage)!=="undefined") {
                var value = sessionStorage.getItem(fieldName);
                if(typeof value !== 'undefined'
                    && value != null ) {
                    if(clean === true) {
                        sessionStorage.removeItem(fieldName);
                    }
                    return JSON.parse(value);
                }
            }

            // if not there try querystring
            return AppLinks.Util.getFieldValueFromQueryString(window.location.search, fieldName);
        },
        /**
         * Check the data-sysadmin-flag from list_application_links vm.
         * @returns {*|jQuery}
         */
        isSysAdmin: function(){
            return AJS.$('#ual.list-links').data("sysadminFlag")
        },
        /**
         * Remove the disabled attribute and any sibling spinner from the button.
         * @param button
         */
        enableButton: function(button){
            button.prop("disabled", false);

            if(button.siblings('.aui-icon-wait').length != 0) {
                button.siblings('.aui-icon-wait').remove();
            }

        },
        /**
         * Mark the button as disabled, and if it is busy add a sibling spinner.
         * The spinner can be optionally before or after the button.
         * @param button
         * @param busy
         * @param after
         */
        disableButton: function(button, busy, after){
            var spinner = '<span class="aui-icon aui-icon-wait aui-icon-wait-padding"></span>';
            if(busy && button.siblings('.aui-icon-wait').length == 0) {
                if(after){
                    button.after(spinner);
                } else {
                    button.before(spinner);
                }
            }

            button.prop("disabled", true);
        },
        /**
         * set the specified button to be enabled or disabled.
         * A disabled button can shown with a spinner if it is busy.
         * @param button
         * @param enabled
         * @param busy
         */
        setButtonEnabledState: function(button, enabled, busy) {
            if(enabled) {
                AppLinks.Util.enableButton(button);
            } else {
                AppLinks.Util.disableButton(button, busy, true);
            }
        },
        /**
         * check the receivedVersion string implies a version equal to or greater than v4.0.0
         * expects a string in the form '([0-9]\.[0-9]\.[0-9])(\.*[0-9A-Za-z-]*)'
         * @param receivedVersion
         * @returns {boolean} true if 4.0.0 or higher, false otherwise.
         */
        isVersion4OrHigher: function(receivedVersion) {
            var receivedVersionParts = receivedVersion.match('([0-9]\.[0-9]\.[0-9])(\.*[0-9A-Za-z-]*)');

            if(receivedVersionParts == null) {
                console.log('Received version is in an unrecognized format ' + receivedVersion );
                return false;
            }

            var majorMinorPatchString = receivedVersionParts[1];
            var prereleaseString = receivedVersionParts[2];
            var majorMinorPatchParts = majorMinorPatchString.split('.');

            // check major version is at least 4
            if(parseFloat(majorMinorPatchParts[0]) < 4) {
                return false;
            }

            if(parseFloat(majorMinorPatchParts[0]) > 4) {
                return true;
            }

            // we have a v4.#.#

            // check minor version is greater than 0
            if(parseFloat(majorMinorPatchParts[1]) > 0) {
                return true;
            }

            // check patch version is greater than 0
            if(parseFloat(majorMinorPatchParts[2]) > 0) {
                return true;
            }

            // we have a 4.0.0 version is it prerelease?
            if(prereleaseString == null
                || prereleaseString === ''
                || prereleaseString === '.SNAPSHOT') {
                // not a prerelease so run with it.
                return true;
            }

            // if in doubt not compatible.
            return false;
        }
    };
})();
