AJS.$(function () {
    /**
     * This function handles the displaying of feedback dialogs and also handles clicks on the "Switch Back" button
     */
    "use strict";
    var $ = AJS.$;
    var SWITCHBACK = 1;
    var FEEDBACK = 2;
    var switchBackTimerId = 0;
    var dialogOpened = 0;
    var applinksSwitchBackButton = $("#applinks-lab-switchback");
    var applinksFeedbackButton = $("#applinks-feedback-button");

    //Feedback button feedback collector
    $.ajax({
        url: "https://jira.atlassian.com/s/e0149ca37bab64d8016b53497b961ef3-T/en_UKdzil1d/65000/131/1.4.25/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?locale=en-UK&collectorId=35047165",
        type: "get",
        cache: true,
        dataType: "script",
        success: enableFeedbackButton
    });

    //Switching back to v2 ui feedback collector
    $.ajax({
        url: "https://jira.atlassian.com/s/b31472787e4b8601717ffa1cfdc1ef0c-T/en_UK-togyvq/65001/131/1.4.25/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?locale=en-UK&collectorId=b89cc0ea",
        type: "get",
        cache: true,
        timeout: 10000,
        dataType: "script",
        success : enableFeedbackDialogOnSwitchback
    });

    // Sets default behaviour to go directly to the old applinks admin page on clicking switch back,
    // using .on syntax so it can be switched off later
    applinksSwitchBackButton.on("click",goToV2AdminPage);

    /**
     * Enables the trigger for the feedback collector which collects feedback when the user switches back to the old UI
     * (The magic numbers are the ids of the issue collectors)
     */
    function enableFeedbackDialogOnSwitchback(){
        window.ATL_JQ_PAGE_PROPS = $.extend(window.ATL_JQ_PAGE_PROPS, {
            'b89cc0ea': {
                triggerFunction: function (showCollectorDialog) {
                    applinksSwitchBackButton.off("click");
                    applinksSwitchBackButton.click(function (e) {
                        e.preventDefault();
                        //This bypasses the feedback collection part if  the collector dialog takes more than 5 seconds to show up
                        switchBackTimerId = setTimeout(function () {
                            goToV2AdminPage();
                        }, 5000);

                        showCollectorDialog();
                        dialogOpened = SWITCHBACK;
                    });
                }
            }
        });
    }

    function enableFeedbackButton() {
        window.ATL_JQ_PAGE_PROPS = $.extend(window.ATL_JQ_PAGE_PROPS, {
            '35047165': {
                triggerFunction: function (showCollectorDialog) {
                    applinksFeedbackButton.click(function (e) {
                        e.preventDefault();
                        showCollectorDialog();
                        dialogOpened = FEEDBACK;
                    });
                }
            }
        });
        $("#applinks-feedback-button").show();
    }

    function handleMessage(e) {
        // the issue collector sends "message" event when the dialog is loaded, but it doesn't have any extra data to
        // identify it as the issue collector, so this uses the origin of it to avoid mixups with any other "message"
        // events
        if (e.originalEvent.origin == 'https://jira.atlassian.com' && switchBackTimerId != 0) {
            clearTimeout(switchBackTimerId);
        }
        //cancelFeedbackDialog is in e.originalEvent.data even if the feedback dialog was closed as a result of
        // feedback being submitted
        if (e.originalEvent.data && e.originalEvent.data === "cancelFeedbackDialog" && dialogOpened === SWITCHBACK) {
            goToV2AdminPage();
        }
    }

    $(window).on("message", handleMessage);

    /**
     * Disables the dark feature for the new ui, and navigates to the old url on success
     */
    function goToV2AdminPage(){
        AppLinks.SPI.disableFeature('V3_UI',
                    function () {
                        AJS.trigger('analyticsEvent',{name:'applinks.switchto.v2'});
                        window.location.href = AppLinks.Urls.Local.admin();
                    }
            );
    }
});
