/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui.velocity;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.auth.OrphanedTrustCertificate;
import com.atlassian.applinks.core.auth.OrphanedTrustDetector;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.application.NonAppLinksApplicationType;
import com.atlassian.applinks.spi.application.StaticUrlApplicationType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.velocity.AbstractVelocityContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListApplicationLinksContext
extends AbstractVelocityContext {
    private final I18nResolver i18nResolver;
    private final OrphanedTrustDetector orphanedTrustDetector;
    private final Set<String> entityTypeIdStrings;
    private final boolean isSysadmin;
    private final boolean hasV3Access;
    private List<OrphanedTrustCertificate> orphanedTrustCertificates;

    ListApplicationLinksContext(InternalHostApplication internalHostApplication, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, InternalTypeAccessor typeAccessor, I18nResolver i18nResolver, DocumentationLinker documentationLinker, OrphanedTrustDetector orphanedTrustDetector, String contextPath, boolean isSysadmin, boolean hasV3Access) {
        super(contextPath, internalHostApplication, batchedJSONi18NBuilderFactory, typeAccessor, documentationLinker);
        this.i18nResolver = i18nResolver;
        this.orphanedTrustDetector = orphanedTrustDetector;
        this.isSysadmin = isSysadmin;
        this.hasV3Access = hasV3Access;
        this.entityTypeIdStrings = Sets.newHashSet((Iterable)Iterables.transform(typeAccessor.getEntityTypesForApplicationType(TypeId.getTypeId((ApplicationType)internalHostApplication.getType())), (Function)new Function<EntityType, String>(){

            public String apply(@Nullable EntityType from) {
                return TypeId.getTypeId((EntityType)from).get();
            }
        }));
    }

    @HtmlSafe
    public JSONArray getNonAppLinksApplicationTypes() {
        return this.getApplicationTypesJSON();
    }

    @HtmlSafe
    public JSONArray getLocalEntityTypeIdStrings() {
        HTMLSafeJSONArray entityTypeIdJSON = new HTMLSafeJSONArray();
        for (String typeId : this.entityTypeIdStrings) {
            entityTypeIdJSON.put(typeId);
        }
        return entityTypeIdJSON;
    }

    public String getApplicationType() {
        return TypeId.getTypeId((ApplicationType)this.internalHostApplication.getType()).get();
    }

    private JSONArray getApplicationTypesJSON() {
        HTMLSafeJSONArray applicationTypesJSON = new HTMLSafeJSONArray();
        Iterable applicationTypes = Iterables.filter((Iterable)this.typeAccessor.getEnabledApplicationTypes(), NonAppLinksApplicationType.class);
        for (NonAppLinksApplicationType nonAppLinksApplicationType : applicationTypes) {
            HTMLSafeJSONObject appType = new HTMLSafeJSONObject();
            try {
                appType.put("typeId", nonAppLinksApplicationType.getId().get());
                appType.put("label", this.i18nResolver.getText(nonAppLinksApplicationType.getI18nKey()));
                applicationTypesJSON.put((Object)appType);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return applicationTypesJSON;
    }

    public Collection<StaticUrlApplicationType> getStaticUrlApplicationTypes() {
        ArrayList<StaticUrlApplicationType> types = new ArrayList<StaticUrlApplicationType>();
        for (StaticUrlApplicationType type : Iterables.filter((Iterable)this.typeAccessor.getEnabledApplicationTypes(), StaticUrlApplicationType.class)) {
            types.add(type);
        }
        return types;
    }

    public List<OrphanedTrustCertificate> getOrphanedTrustCertificates() {
        if (this.orphanedTrustCertificates == null) {
            this.orphanedTrustCertificates = this.orphanedTrustDetector.findOrphanedTrustCertificates();
        }
        return this.orphanedTrustCertificates;
    }

    public UnescapedI18nResolver getI18nNoEscape() {
        return new UnescapedI18nResolver();
    }

    public boolean isSysadmin() {
        return this.isSysadmin;
    }

    public boolean hasV3Access() {
        return this.hasV3Access;
    }

    protected static class HTMLSafeJSONArray
    extends JSONArray {
        protected HTMLSafeJSONArray() {
        }

        @HtmlSafe
        public String toString() {
            return super.toString();
        }
    }

    protected static class HTMLSafeJSONObject
    extends JSONObject {
        protected HTMLSafeJSONObject() {
        }

        @HtmlSafe
        public String toString() {
            return super.toString();
        }
    }

    public class UnescapedI18nResolver {
        @HtmlSafe
        public String getText(String key, String ... arguments) {
            return ListApplicationLinksContext.this.i18nResolver.getText(key, (Serializable[])arguments);
        }
    }
}

