/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.core.plugin.AuthenticationProviderModuleDescriptor;
import com.atlassian.applinks.core.rest.context.CurrentContext;
import com.atlassian.applinks.core.rest.model.I18NEntryListEntity;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedJSONi18NBuilderFactory {
    private final LocaleResolver localeResolver;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final PluginAccessor pluginAccessor;
    private final I18nResolver i18nResolver;
    private final TypeAccessor typeAccessor;
    private static final Logger logger = LoggerFactory.getLogger(BatchedJSONi18NBuilderFactory.class);

    public BatchedJSONi18NBuilderFactory(LocaleResolver localeResolver, JaxbJsonMarshaller jaxbJsonMarshaller, PluginAccessor pluginAccessor, I18nResolver i18nResolver, TypeAccessor typeAccessor) {
        this.localeResolver = localeResolver;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.pluginAccessor = pluginAccessor;
        this.i18nResolver = i18nResolver;
        this.typeAccessor = typeAccessor;
    }

    public BatchedJSONI18nBuilder builder() {
        return new BatchedJSONI18nBuilder();
    }

    public class BatchedJSONI18nBuilder {
        private final Map<String, String> properties = new HashMap<String, String>();

        private void put(String key, String value) {
            if (this.properties.containsKey(key)) {
                logger.warn("Duplicate i18n entry for key '" + key + "'");
            }
            this.properties.put(key, value);
        }

        private void putAll(Map<String, String> properties) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        public BatchedJSONI18nBuilder withProperties(String prefix) {
            HttpServletRequest request = CurrentContext.getHttpServletRequest();
            Locale locale = BatchedJSONi18NBuilderFactory.this.localeResolver.getLocale(request);
            this.putAll(BatchedJSONi18NBuilderFactory.this.i18nResolver.getAllTranslationsForPrefix(prefix, locale));
            return this;
        }

        public BatchedJSONI18nBuilder with(Map<String, String> properties) {
            this.putAll(properties);
            return this;
        }

        public BatchedJSONI18nBuilder with(String key, String value) {
            this.put(key, value);
            return this;
        }

        public BatchedJSONI18nBuilder withPluggableApplinksModules() {
            String key;
            for (ApplicationType applicationType : BatchedJSONi18NBuilderFactory.this.typeAccessor.getEnabledApplicationTypes()) {
                key = "applinks.application.type." + TypeId.getTypeId((ApplicationType)applicationType);
                this.put(key, BatchedJSONi18NBuilderFactory.this.i18nResolver.getText(applicationType.getI18nKey()));
            }
            for (EntityType entityType : BatchedJSONi18NBuilderFactory.this.typeAccessor.getEnabledEntityTypes()) {
                key = "applinks.entity.type." + TypeId.getTypeId((EntityType)entityType);
                this.put(key, BatchedJSONi18NBuilderFactory.this.i18nResolver.getText(entityType.getI18nKey()));
                String pluralKey = "applinks.entity.type.plural." + TypeId.getTypeId((EntityType)entityType);
                this.put(pluralKey, BatchedJSONi18NBuilderFactory.this.i18nResolver.getText(entityType.getPluralizedI18nKey()));
            }
            for (AuthenticationProviderModuleDescriptor authProvider : BatchedJSONi18NBuilderFactory.this.pluginAccessor.getEnabledModuleDescriptorsByClass(AuthenticationProviderModuleDescriptor.class)) {
                key = "applinks.auth.provider." + authProvider.getModule().getAuthenticationProviderClass().getName();
                this.put(key, BatchedJSONi18NBuilderFactory.this.i18nResolver.getText(authProvider.getI18nNameKey()));
            }
            return this;
        }

        public String build() {
            return BatchedJSONi18NBuilderFactory.this.jaxbJsonMarshaller.marshal((Object)new I18NEntryListEntity(this.properties));
        }
    }
}

