/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class BaseRestEntity
extends LinkedHashMap<String, Object> {
    @Nonnull
    public static BaseRestEntity createSingleFieldEntity(@Nonnull String fieldName, @Nullable Object value) {
        return new BaseRestEntity((Map<String, Object>)Collections.singletonMap(Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName"), value));
    }

    public BaseRestEntity() {
        this(Collections.emptyMap());
    }

    public BaseRestEntity(@Nonnull Map<String, Object> values) {
        this.putAll((Map)Preconditions.checkNotNull(values, (Object)"values"));
    }

    public static class Builder {
        private final Map<String, Object> fields = Maps.newLinkedHashMap();

        @Nonnull
        public Builder add(@Nonnull String fieldName, @Nullable Object value) {
            Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName");
            this.fields.put(fieldName, value);
            return this;
        }

        @Nonnull
        public BaseRestEntity build() {
            return new BaseRestEntity(this.fields);
        }
    }
}

