/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.exception;

import com.atlassian.applinks.internal.exception.ServiceException;
import com.atlassian.applinks.internal.exception.ServiceExceptionFactory;
import com.atlassian.applinks.internal.util.i18n.I18nKey;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class DefaultServiceExceptionFactory
implements ServiceExceptionFactory {
    @VisibleForTesting
    static final String DEFAULT_MESSAGE_FIELD_NAME = "DEFAULT_MESSAGE";
    private final I18nResolver i18nResolver;

    public DefaultServiceExceptionFactory(@Nonnull I18nResolver i18nResolver) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    @Override
    @Nonnull
    public <E extends ServiceException> E create(@Nonnull Class<E> exceptionClass, Serializable ... args) {
        Preconditions.checkNotNull(exceptionClass, (Object)"exceptionClass");
        Preconditions.checkNotNull((Object)args, (Object)"args");
        try {
            String defaultMessageKey = (String)exceptionClass.getField(DEFAULT_MESSAGE_FIELD_NAME).get(null);
            Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)defaultMessageKey), (Object)"Default message key must not be empty");
            return this.create(exceptionClass, I18nKey.create(defaultMessageKey, args));
        }
        catch (NoSuchFieldException e) {
            return this.create(exceptionClass, I18nKey.create("applinks.service.error.default.message.not.specified", new Serializable[]{exceptionClass.getName()}));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate " + exceptionClass.getName(), e);
        }
    }

    @Override
    @Nonnull
    public <E extends ServiceException> E create(@Nonnull Class<E> exceptionClass, @Nonnull I18nKey i18nKey) {
        Preconditions.checkNotNull(exceptionClass, (Object)"exceptionClass");
        Preconditions.checkNotNull((Object)i18nKey, (Object)"i18nKey");
        try {
            return (E)((ServiceException)exceptionClass.getConstructor(String.class).newInstance(this.i18nResolver.getText((Message)i18nKey)));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate " + exceptionClass.getName(), e);
        }
    }

    @Override
    @Nonnull
    public <E extends ServiceException> E create(@Nonnull Class<E> exceptionClass, @Nonnull I18nKey i18nKey, @Nonnull Throwable cause) {
        Preconditions.checkNotNull(exceptionClass, (Object)"exceptionClass");
        Preconditions.checkNotNull((Object)i18nKey, (Object)"i18nKey");
        Preconditions.checkNotNull((Object)cause, (Object)"cause");
        try {
            return (E)((ServiceException)exceptionClass.getConstructor(String.class, Throwable.class).newInstance(this.i18nResolver.getText((Message)i18nKey), cause));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate " + exceptionClass.getName(), e);
        }
    }
}

