/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.util;

import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectHelper {
    public static final int MAX_REDIRECTS = 3;
    private static final Logger log = LoggerFactory.getLogger(RedirectHelper.class);
    private int redirects = 0;

    public String getNextRedirectLocation(Response response) throws ResponseException {
        String location = response.getHeader("location");
        ++this.redirects;
        return location;
    }

    public boolean responseShouldRedirect(Response response) {
        return this.isRedirectStatusCode(response) && this.hasLocation(response) && this.notExceededMaximumRedirects();
    }

    private boolean isRedirectStatusCode(Response response) {
        return response.getStatusCode() >= 300 && response.getStatusCode() < 400;
    }

    private boolean hasLocation(Response response) {
        String location = response.getHeader("location");
        if (StringUtils.isBlank((String)location)) {
            log.warn("HTTP response returned redirect code " + response.getStatusCode() + " but did not provide a location header");
        }
        return StringUtils.isNotBlank((String)location);
    }

    private boolean notExceededMaximumRedirects() {
        if (this.redirects >= 3) {
            log.warn("Maximum of 3 redirects reached.");
            return false;
        }
        return true;
    }
}

