/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksInterceptor;
import com.atlassian.applinks.core.rest.context.ContextInterceptor;
import com.atlassian.applinks.core.rest.model.ApplicationLinkInfoEntity;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.applinks.spi.link.MutatingEntityLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.resource.Singleton;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="applicationlinkInfo")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
@InterceptorChain(value={ContextInterceptor.class, AdminApplicationLinksInterceptor.class})
public class ApplicationLinkInfoResource {
    private final PluginAccessor pluginAccessor;
    private final ApplicationLinkService applicationLinkService;
    private final I18nResolver i18nResolver;
    private final MutatingEntityLinkService entityLinkService;
    private final InternalHostApplication internalHostApplication;
    private final TypeAccessor typeAccessor;

    public ApplicationLinkInfoResource(PluginAccessor pluginAccessor, ApplicationLinkService applicationLinkService, I18nResolver i18nResolver, MutatingEntityLinkService entityLinkService, InternalHostApplication internalHostApplication, TypeAccessor typeAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.applicationLinkService = applicationLinkService;
        this.i18nResolver = i18nResolver;
        this.entityLinkService = entityLinkService;
        this.internalHostApplication = internalHostApplication;
        this.typeAccessor = typeAccessor;
    }

    @GET
    @Path(value="id/{id}")
    public Response getConfiguredAuthenticationTypesAndEntityLinksForApplicationLink(@PathParam(value="id") ApplicationId id) {
        int entityCount;
        ApplicationLink applicationLink;
        try {
            applicationLink = this.applicationLinkService.getApplicationLink(id);
            entityCount = Lists.newArrayList((Iterable)this.entityLinkService.getEntityLinksForApplicationLink(applicationLink)).size();
        }
        catch (TypeNotInstalledException e) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.type.not.installed", new Serializable[]{e.getType()}));
        }
        if (applicationLink == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{id.get()}));
        }
        ArrayList<String> configuredAuthProviders = new ArrayList<String>();
        for (AuthenticationProviderPluginModule authenticationProviderPluginModule : this.pluginAccessor.getEnabledModulesByClass(AuthenticationProviderPluginModule.class)) {
            AuthenticationProvider authenticationProvider = authenticationProviderPluginModule.getAuthenticationProvider(applicationLink);
            if (authenticationProvider == null) continue;
            configuredAuthProviders.add(authenticationProviderPluginModule.getAuthenticationProviderClass().getName());
        }
        List entityTypes = this.pluginAccessor.getEnabledModulesByClass(EntityType.class);
        Iterable hostApplicationEntityTypes = Iterables.filter((Iterable)entityTypes, (Predicate)new Predicate<EntityType>(){

            public boolean apply(@Nullable EntityType input) {
                return TypeId.getTypeId((ApplicationType)ApplicationLinkInfoResource.this.internalHostApplication.getType()).equals((Object)TypeId.getTypeId((ApplicationType)ApplicationLinkInfoResource.this.typeAccessor.getApplicationType(input.getApplicationType())));
            }
        });
        Iterable hostAppEntityTypesAsString = Iterables.transform((Iterable)hostApplicationEntityTypes, (Function)new Function<EntityType, String>(){

            public String apply(@Nullable EntityType from) {
                return TypeId.getTypeId((EntityType)from).get();
            }
        });
        Iterable remoteApplicationEntityTypes = Iterables.filter((Iterable)entityTypes, (Predicate)new Predicate<EntityType>(){

            public boolean apply(@Nullable EntityType input) {
                return TypeId.getTypeId((ApplicationType)applicationLink.getType()).equals((Object)TypeId.getTypeId((ApplicationType)ApplicationLinkInfoResource.this.typeAccessor.getApplicationType(input.getApplicationType())));
            }
        });
        Iterable remoteApplicationEntityTypesAsString = Iterables.transform((Iterable)remoteApplicationEntityTypes, (Function)new Function<EntityType, String>(){

            public String apply(@Nullable EntityType from) {
                return TypeId.getTypeId((EntityType)from).get();
            }
        });
        return RestUtil.ok(new ApplicationLinkInfoEntity(configuredAuthProviders, entityCount, Lists.newArrayList((Iterable)hostAppEntityTypesAsString), Lists.newArrayList((Iterable)remoteApplicationEntityTypesAsString)));
    }
}

