/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.plugin;

import com.atlassian.applinks.core.plugin.DescriptorWeightAttributeParser;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.util.concurrent.NotNull;
import java.util.Comparator;
import org.dom4j.Element;

public class AuthenticationProviderModuleDescriptor
extends AbstractModuleDescriptor<AuthenticationProviderPluginModule> {
    public static Comparator<AuthenticationProviderModuleDescriptor> BY_WEIGHT = new Comparator<AuthenticationProviderModuleDescriptor>(){

        @Override
        public int compare(AuthenticationProviderModuleDescriptor o1, AuthenticationProviderModuleDescriptor o2) {
            return o1.getWeight() - o2.getWeight();
        }
    };
    private int weight;

    public AuthenticationProviderModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = DescriptorWeightAttributeParser.getWeight(element);
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@class").withError("No AuthenticationProviderPluginModule implementation class specified."), ValidationPattern.test((String)"@i18n-name-key").withError("No i18n-name-key specified.")});
    }

    public AuthenticationProviderPluginModule getModule() {
        return (AuthenticationProviderPluginModule)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public int getWeight() {
        return this.weight;
    }
}

