/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.docs;

import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.sal.api.message.I18nResolver;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class DocumentationLinkerImpl
implements DocumentationLinker {
    private final InternalHostApplication internalHostApplication;
    private final I18nResolver i18nResolver;

    public DocumentationLinkerImpl(InternalHostApplication internalHostApplication, I18nResolver i18nResolver) {
        this.internalHostApplication = internalHostApplication;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public URI getLink(String pageKey) {
        return this.getLink(pageKey, null);
    }

    @Override
    public URI getLink(String pageKey, String sectionKey) {
        String pageName = this.i18nResolver.getText(pageKey);
        if (!StringUtils.isEmpty((String)sectionKey)) {
            String sectionPrefix = StringUtils.remove((String)pageName, (String)"+");
            pageName = pageName + "#" + sectionPrefix + "-" + this.i18nResolver.getText(sectionKey);
        }
        return URIUtil.uncheckedConcatenate(this.internalHostApplication.getDocumentationBaseUrl(), "/" + pageName);
    }
}

