/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.trusted;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.event.BeforeApplicationLinkDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class TrustedApplicationReaper
implements DisposableBean {
    private final EventPublisher eventPublisher;
    private final TrustedApplicationsConfigurationManager trustedAppsManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public TrustedApplicationReaper(EventPublisher eventPublisher, TrustedApplicationsConfigurationManager trustedAppsManager) {
        this.eventPublisher = eventPublisher;
        this.trustedAppsManager = trustedAppsManager;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onApplicationLinkDeleted(BeforeApplicationLinkDeletedEvent deletedEvent) {
        ApplicationLink link = deletedEvent.getApplicationLink();
        Object value = link.getProperty("trustedapps.incoming.applicationId");
        if (value != null) {
            this.trustedAppsManager.deleteApplication(value.toString());
            this.logger.debug("Removed certificate (trusted apps Id: {}) for deleted application link {}", (Object)value.toString(), (Object)link.getId());
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

