/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth.servlets.serviceprovider;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.core.auth.AbstractAdminOnlyAuthServlet;
import com.atlassian.applinks.core.auth.oauth.OAuthHelper;
import com.atlassian.applinks.core.auth.oauth.RequestUtil;
import com.atlassian.applinks.core.auth.oauth.servlets.AbstractOAuthConfigServlet;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OutboundRedirectServlet
extends AbstractOAuthConfigServlet {
    public static final String SUPPORT_APPLINK_PARAM = "supportsAppLinks";
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final WebSudoManager webSudoManager;
    private final HostApplication hostApplication;

    protected OutboundRedirectServlet(I18nResolver i18nResolver, MessageFactory messageFactory, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, ApplicationLinkService applicationLinkService, AdminUIAuthenticator adminUIAuthenticator, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, DocumentationLinker documentationLinker, LoginUriProvider loginUriProvider, InternalHostApplication internalHostApplication, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, AuthenticationConfigurationManager authenticationConfigurationManager, WebSudoManager webSudoManager, HostApplication hostApplication) {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, applicationLinkService, adminUIAuthenticator, batchedJSONi18NBuilderFactory, documentationLinker, loginUriProvider, internalHostApplication, xsrfTokenAccessor, xsrfTokenValidator);
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.webSudoManager = webSudoManager;
        this.hostApplication = hostApplication;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            ApplicationLink link = this.getRequiredApplicationLink(request);
            boolean supportsAppLinks = Boolean.parseBoolean(request.getParameter(SUPPORT_APPLINK_PARAM));
            String uri = this.getOutgoingConfigUrl(link, supportsAppLinks, request);
            resp.sendRedirect(uri);
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(request, resp);
        }
    }

    public String getOutgoingConfigUrl(ApplicationLink link, boolean supportsAppLinks, HttpServletRequest request) {
        boolean oAuthPluginInstalled = OAuthHelper.isOAuthPluginInstalled(link);
        String configUri = supportsAppLinks ? link.getDisplayUrl() + "/plugins/servlet/applinks/auth/conf/oauth/add-consumer-by-url/" + this.hostApplication.getId() + "?" + "uiposition" + "=remote" + "&" + AbstractAdminOnlyAuthServlet.HOST_URL_PARAM + "=" + URIUtil.utf8Encode(RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl())).toString() + "&" + "outgoing2LOEnabled" + "=" + this.authenticationConfigurationManager.isConfigured(link.getId(), TwoLeggedOAuthAuthenticationProvider.class) + "&" + "outgoing2LOiEnabled" + "=" + this.authenticationConfigurationManager.isConfigured(link.getId(), TwoLeggedOAuthWithImpersonationAuthenticationProvider.class) + "&" + "oauth-outgoing-enabled" + "=" + this.authenticationConfigurationManager.isConfigured(link.getId(), OAuthAuthenticationProvider.class) : (oAuthPluginInstalled ? RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) + "/plugins/servlet/applinks/auth/conf/oauth/outbound/atlassian/" + link.getId().toString() : RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) + "/plugins/servlet/applinks/auth/conf/oauth/outbound/3rdparty/" + link.getId().toString());
        return configUri;
    }
}

