/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.accesslevel.AuthenticationAwareApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.core.auth.oauth.OAuthRedirectingApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.oauth.OAuthRequest;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthApplinksResponseHandler<R>
extends OAuthRedirectingApplicationLinkResponseHandler
implements AuthenticationAwareApplicationLinkResponseHandler<R> {
    private static final Logger log = LoggerFactory.getLogger(OAuthApplinksResponseHandler.class);
    private final AuthenticationAwareApplicationLinkResponseHandler<R> applicationLinkResponseHandler;

    public OAuthApplinksResponseHandler(ApplicationLinkResponseHandler<R> applicationLinkResponseHandler, ConsumerTokenStoreService consumerTokenStoreService, OAuthRequest wrappedRequest, ApplicationId applicationId, String username, boolean followRedirects) {
        super(wrappedRequest, consumerTokenStoreService, applicationId, username, followRedirects);
        this.applicationLinkResponseHandler = this.getAuthenticationAwareApplicationLinkResponseHandler(applicationLinkResponseHandler);
    }

    public OAuthApplinksResponseHandler(ApplicationLinkResponseHandler<R> applicationLinkResponseHandler, OAuthRequest wrappedRequest, ApplicationId applicationId, boolean followRedirects) {
        super(wrappedRequest, null, applicationId, null, followRedirects);
        this.applicationLinkResponseHandler = this.getAuthenticationAwareApplicationLinkResponseHandler(applicationLinkResponseHandler);
    }

    public R credentialsRequired(Response response) throws ResponseException {
        return (R)this.applicationLinkResponseHandler.credentialsRequired(response);
    }

    @Override
    public R credentialsRequired(Response response, String problem, String problemAdvice) throws ResponseException {
        return this.applicationLinkResponseHandler.credentialsRequired(response, problem, problemAdvice);
    }

    @Override
    public R authenticationFailed(Response response, String problem, String problemAdvice) throws ResponseException {
        return this.applicationLinkResponseHandler.authenticationFailed(response, problem, problemAdvice);
    }

    public R handle(Response response) throws ResponseException {
        this.checkForOAuthProblemAndRemoveConsumerTokenIfNecessary(response);
        if (this.hasTokenProblems) {
            return this.applicationLinkResponseHandler.credentialsRequired(response, this.authenticationProblem, this.authenticationProblemAdvice);
        }
        if (this.authenticationProblem != null) {
            try {
                return this.applicationLinkResponseHandler.authenticationFailed(response, this.authenticationProblem, this.authenticationProblemAdvice);
            }
            catch (NoSuchMethodError nsme) {
                log.warn("Unable to parse authentication problem '" + this.authenticationProblem + "'. Running plugin against an old API?", (Throwable)nsme);
            }
        }
        if (this.followRedirects && this.redirectHelper.responseShouldRedirect(response)) {
            this.wrappedRequest.setUrl(this.redirectHelper.getNextRedirectLocation(response));
            return (R)this.wrappedRequest.execute((ApplicationLinkResponseHandler)this);
        }
        return (R)this.applicationLinkResponseHandler.handle(response);
    }

    private AuthenticationAwareApplicationLinkResponseHandler<R> getAuthenticationAwareApplicationLinkResponseHandler(final ApplicationLinkResponseHandler<R> applicationLinkResponseHandler) {
        return new AuthenticationAwareApplicationLinkResponseHandler<R>(){

            @Override
            public R authenticationFailed(Response response, String reason, String authenticationProblemAdvice) throws ResponseException {
                if (AuthenticationAwareApplicationLinkResponseHandler.class.isAssignableFrom(applicationLinkResponseHandler.getClass())) {
                    return ((AuthenticationAwareApplicationLinkResponseHandler)applicationLinkResponseHandler).authenticationFailed(response, reason, authenticationProblemAdvice);
                }
                return null;
            }

            public R credentialsRequired(Response response) throws ResponseException {
                return applicationLinkResponseHandler.credentialsRequired(response);
            }

            @Override
            public R credentialsRequired(Response response, String problem, String problemAdvice) throws ResponseException {
                if (AuthenticationAwareApplicationLinkResponseHandler.class.isAssignableFrom(applicationLinkResponseHandler.getClass())) {
                    return ((AuthenticationAwareApplicationLinkResponseHandler)applicationLinkResponseHandler).credentialsRequired(response, problem, problemAdvice);
                }
                return applicationLinkResponseHandler.credentialsRequired(response);
            }

            public R handle(Response response) throws ResponseException {
                return applicationLinkResponseHandler.handle(response);
            }
        };
    }
}

