/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.basic;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.types.BasicAuthenticationProvider;
import com.atlassian.applinks.core.auth.ApplicationLinkRequestAdaptor;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;

public class BasicAuthRequestFactoryImpl
implements ApplicationLinkRequestFactory {
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ApplicationLink applicationLink;
    private final RequestFactory requestFactory;

    public BasicAuthRequestFactoryImpl(AuthenticationConfigurationManager authenticationConfigurationManager, ApplicationLink applicationLink, RequestFactory requestFactory) {
        this.authenticationConfigurationManager = (AuthenticationConfigurationManager)Preconditions.checkNotNull((Object)authenticationConfigurationManager);
        this.applicationLink = (ApplicationLink)Preconditions.checkNotNull((Object)applicationLink);
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull((Object)requestFactory);
    }

    public ApplicationLinkRequest createRequest(Request.MethodType methodType, String s) {
        Map config = this.authenticationConfigurationManager.getConfiguration(this.applicationLink.getId(), BasicAuthenticationProvider.class);
        if (config == null) {
            throw new IllegalStateException(String.format("Basic HTTP Authentication is not configured for application link %s", this.applicationLink));
        }
        return new ApplicationLinkRequestAdaptor(this.requestFactory.createRequest(methodType, s)).addBasicAuthentication((String)config.get(USERNAME_KEY), (String)config.get(PASSWORD_KEY));
    }

    public URI getAuthorisationURI() {
        return null;
    }

    public URI getAuthorisationURI(URI callback) {
        return null;
    }
}

