/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.core.auth.OrphanedTrustCertificate;
import com.atlassian.applinks.core.auth.OrphanedTrustDetector;
import com.atlassian.applinks.core.auth.oauth.OAuthOrphanedTrustDetector;
import com.atlassian.applinks.core.auth.trusted.TrustedAppsOrphanedTrustDetector;
import java.util.ArrayList;
import java.util.List;

public class DelegatingOrphanedTrustDetector
implements OrphanedTrustDetector {
    private final OAuthOrphanedTrustDetector oAuthOrphanedTrustDetector;
    private final TrustedAppsOrphanedTrustDetector trustedAppsOrphanedTrustDetector;

    public DelegatingOrphanedTrustDetector(OAuthOrphanedTrustDetector oAuthOrphanedTrustDetector, TrustedAppsOrphanedTrustDetector trustedAppsOrphanedTrustDetector) {
        this.oAuthOrphanedTrustDetector = oAuthOrphanedTrustDetector;
        this.trustedAppsOrphanedTrustDetector = trustedAppsOrphanedTrustDetector;
    }

    @Override
    public List<OrphanedTrustCertificate> findOrphanedTrustCertificates() {
        ArrayList<OrphanedTrustCertificate> certificates = new ArrayList<OrphanedTrustCertificate>();
        certificates.addAll(this.trustedAppsOrphanedTrustDetector.findOrphanedTrustCertificates());
        certificates.addAll(this.oAuthOrphanedTrustDetector.findOrphanedTrustCertificates());
        return certificates;
    }

    @Override
    public void deleteTrustCertificate(String id, OrphanedTrustCertificate.Type type) {
        switch (type) {
            case TRUSTED_APPS: {
                this.trustedAppsOrphanedTrustDetector.deleteTrustCertificate(id, type);
                break;
            }
            case OAUTH: {
                this.oAuthOrphanedTrustDetector.deleteTrustCertificate(id, type);
                break;
            }
            case OAUTH_SERVICE_PROVIDER: {
                this.oAuthOrphanedTrustDetector.deleteTrustCertificate(id, type);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported OrphanedTrustCertificate.Type: " + (Object)((Object)type));
            }
        }
    }

    @Override
    public void addOrphanedTrustToApplicationLink(String id, OrphanedTrustCertificate.Type type, ApplicationId applicationId) {
        switch (type) {
            case TRUSTED_APPS: {
                this.trustedAppsOrphanedTrustDetector.addOrphanedTrustToApplicationLink(id, type, applicationId);
                break;
            }
            case OAUTH: {
                this.oAuthOrphanedTrustDetector.addOrphanedTrustToApplicationLink(id, type, applicationId);
                break;
            }
            case OAUTH_SERVICE_PROVIDER: {
                this.oAuthOrphanedTrustDetector.addOrphanedTrustToApplicationLink(id, type, applicationId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported OrphanedTrustCertificate.Type: " + (Object)((Object)type));
            }
        }
    }
}

